package org.gcube.data.analysis.tabulardata.model.column.factories;

import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;

public class DimensionColumnFactory extends BaseColumnFactory{
	
	public static Column create(LocalizedText label, ColumnRelationship columnRelationship){
		Column result = create(new DimensionColumnType(), label, new IntegerType());
		result.setRelationship(columnRelationship);
		return result;
	}
	
	public static Column create(ColumnRelationship columnRelationship){
		Column result = create(new DimensionColumnType(), new IntegerType());
		result.setRelationship(columnRelationship);
		return result;
	}

}
