package org.gcube.data.analysis.tabulardata.model.column.factories;

import java.util.List;

import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.DescriptionsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;

public class ValidationColumnFactory extends BaseColumnFactory {

	public static Column create(LocalizedText name, DataValidationMetadata validationMetadata) {
		Column column = create(new ValidationColumnType(), name, new BooleanType());
		column.setMetadata(validationMetadata);
		return column;
	}

	public static Column create(List<LocalizedText> names, List<LocalizedText> descriptions,
			DataValidationMetadata validationMetadata) {
		Column column = create(new ValidationColumnType(), new BooleanType());
		if (names.size() < 1)
			throw new IllegalArgumentException("Must provide at least one label");
		column.setMetadata(new NamesMetadata(names));
		if (descriptions.size() > 0)
			column.setMetadata(new DescriptionsMetadata(names));
		column.setMetadata(validationMetadata);
		return column;
	}

}
