/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.OperationNotFoundException;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.dsl.Logicals;
import org.gcube.data.analysis.tabulardata.metadata.StorableRule;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.RuleMapping;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.StorableTabularResource;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.task.TaskContext;
import org.gcube.data.analysis.tabulardata.utils.Factories;
import org.gcube.data.analysis.tabulardata.utils.InternalInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OperationUtil {
    @Inject
    private Factories factories;
    @Inject
    private CubeManager cubeManager;
    private Logger logger = LoggerFactory.getLogger(OperationUtil.class);

    public void addPostValidations(TaskContext context, StorableTabularResource str) throws OperationNotFoundException {
        ArrayList<InternalInvocation> invocations = new ArrayList<InternalInvocation>();
        if (!str.getRules().isEmpty() && str.getTableId() != null) {
            invocations.add(this.getRulesInvocation(str.getRules(), str.getTableId().longValue()));
        }
        long TABLETYPEVALIDATION_OP_ID = 5011L;
        invocations.add(this.getInvocationById(5011L, new HashMap()));
        context.addPostValidations(invocations);
    }

    public void addPostOperations(TaskContext context) throws OperationNotFoundException {
        long CREATEVIEW_OP_ID = 1003L;
        context.addPostOperations(Collections.singletonList(this.getInvocationById(1003L, new HashMap())));
    }

    public InternalInvocation getRulesInvocation(List<RuleMapping> ruleMappings, long tableId) throws OperationNotFoundException {
        if (ruleMappings == null || ruleMappings.isEmpty()) {
            return null;
        }
        String EXPRESSION_PARAMETER = "expression";
        String COMPOSITE_RULE_PARAMETER = "rules";
        String NAME_PARAMETER = "name";
        long RULE_VALIDATION_OP = 5009L;
        WorkerFactory factory = this.factories.get(new OperationId(5009L));
        if (factory == null) {
            this.logger.error("operation with id {} not found", (Object)5009L);
            throw new OperationNotFoundException("operation with id 5009 not found");
        }
        Table table = this.cubeManager.getTable(new TableId(tableId));
        ArrayList rulesParameterInstance = new ArrayList();
        for (RuleMapping ruleMapping : ruleMappings) {
            StorableRule storableRule = ruleMapping.getStorableRule();
            this.logger.debug("rule found " + storableRule.getName());
            HashMap<String, Column> internalMapping = new HashMap<String, Column>();
            if (ruleMapping.getColumnLocalId() == null) {
                for (Map.Entry entry : ruleMapping.getPlaceholderColumnMapping().entrySet()) {
                    internalMapping.put((String)entry.getKey(), table.getColumnById(new ColumnLocalId((String)entry.getValue())));
                }
            } else {
                internalMapping.put("placeholder", table.getColumnById(new ColumnLocalId(ruleMapping.getColumnLocalId())));
            }
            Expression expression = storableRule.getRule().getExpression(table.getId(), internalMapping);
            HashMap<String, Object> singleRuleparameters = new HashMap<String, Object>();
            singleRuleparameters.put("expression", expression);
            singleRuleparameters.put("name", storableRule.getName());
            rulesParameterInstance.add(singleRuleparameters);
        }
        InternalInvocation internalInvocation = new InternalInvocation(Collections.singletonMap("rules", rulesParameterInstance), factory);
        return internalInvocation;
    }

    public InternalInvocation getInvocationById(long opId, Map<String, Object> parameters) throws OperationNotFoundException {
        WorkerFactory factory = this.factories.get(new OperationId(opId));
        if (factory == null) {
            this.logger.error("operation with id {} not found", (Object)opId);
            throw new OperationNotFoundException("operation with id " + opId + " not found");
        }
        return new InternalInvocation(parameters, factory);
    }

    public InternalInvocation getRemoveInvalidEntryInvocation(Table currentTable, List<ColumnLocalId> validationColumns) {
        ColumnReference expression;
        String EXPRESSION_PARAMETER = "expression";
        long FILTER_OP = 3201L;
        WorkerFactory factory = this.factories.get(new OperationId(3201L));
        if (factory == null) {
            this.logger.error("operation with id {} not found", (Object)3201L);
            throw new RuntimeException("cannot remove Invalid entry (unexpected error)");
        }
        if (validationColumns.size() == 1) {
            expression = new ColumnReference(currentTable.getId(), validationColumns.get(0));
        } else {
            ArrayList<ColumnReference> expressions = new ArrayList<ColumnReference>();
            for (ColumnLocalId column : validationColumns) {
                expressions.add(new ColumnReference(currentTable.getId(), column));
            }
            expression = Logicals.and((Expression[])expressions.toArray(new Expression[expressions.size()]));
        }
        return new InternalInvocation(Collections.singletonMap("expression", expression), factory);
    }
}

