/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.task.executor;

import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.enterprise.event.Event;
import javax.persistence.EntityManager;
import javax.persistence.RollbackException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.gcube.data.analysis.tabulardata.cleaner.GarbageCollector;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.WorkerResult;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.RollbackTaskInfo;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.exceptions.TabularResourceLockedException;
import org.gcube.data.analysis.tabulardata.metadata.StorableHistoryStep;
import org.gcube.data.analysis.tabulardata.metadata.resources.StorableResource;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.ColumnId;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.RelationLink;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.StorableTabularResource;
import org.gcube.data.analysis.tabulardata.metadata.task.StorableTask;
import org.gcube.data.analysis.tabulardata.model.metadata.common.TableDescriptorMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.TableRelationship;
import org.gcube.data.analysis.tabulardata.model.resources.TableResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.StatementContainer;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.task.RunnableTask;
import org.gcube.data.analysis.tabulardata.task.TabularResourceDescriptor;
import org.gcube.data.analysis.tabulardata.task.TaskContext;
import org.gcube.data.analysis.tabulardata.task.executor.ExecutionHolder;
import org.gcube.data.analysis.tabulardata.task.executor.TaskHandler;
import org.gcube.data.analysis.tabulardata.task.executor.operation.creators.OperationWorkerCreator;
import org.gcube.data.analysis.tabulardata.task.executor.operation.creators.RollbackWorkerCreator;
import org.gcube.data.analysis.tabulardata.task.executor.operation.creators.WorkerCreator;
import org.gcube.data.analysis.tabulardata.utils.EntityManagerHelper;
import org.gcube.data.analysis.tabulardata.utils.OperationUtil;
import org.gcube.data.analysis.tabulardata.utils.ResourceCreated;
import org.gcube.data.analysis.tabulardata.utils.TableContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskWrapper
implements Runnable {
    private EntityManager entityManager;
    private CubeManager cubeManager;
    private TaskContext taskContext;
    private StorableTabularResource tabularResource;
    private StorableTask task;
    private boolean resumedExecution;
    private GarbageCollector garbageCollector;
    private ExecutionHolder executionHolder = new ExecutionHolder();
    private Event<ResourceCreated> tableResourceEvent;
    private OperationUtil operationUtil;
    private TaskHandler taskHandler;
    private RunnableTask onSuccessEvent;
    private boolean parallelizableExecution = false;
    private boolean aborted;
    private static Logger logger = LoggerFactory.getLogger(TaskWrapper.class);
    private String threadGroupName = null;
    private DatabaseConnectionProvider connectionProvider;

    public TaskWrapper(EntityManagerHelper entityManagerHelper, CubeManager cubeManager, TaskContext taskContext, StorableTabularResource tabularResource, StorableTask task, GarbageCollector garbageCollector, Event<ResourceCreated> tableResourceEvent, DatabaseConnectionProvider connectionProvider, OperationUtil operationUtil, boolean resumedExecution) throws TabularResourceLockedException {
        this.entityManager = entityManagerHelper.getEntityManager();
        this.cubeManager = cubeManager;
        this.taskContext = taskContext;
        this.tabularResource = tabularResource;
        this.task = task;
        this.resumedExecution = resumedExecution;
        this.garbageCollector = garbageCollector;
        this.tableResourceEvent = tableResourceEvent;
        this.parallelizableExecution = this.taskContext.isParallelizableExecution();
        this.connectionProvider = connectionProvider;
        this.operationUtil = operationUtil;
        this.checkAndlockTabularResource();
    }

    private void checkAndlockTabularResource() {
        this.tabularResource = (StorableTabularResource)this.entityManager.find(StorableTabularResource.class, (Object)this.tabularResource.getId());
        try {
            this.entityManager.getTransaction().begin();
            logger.trace("tabularResource is locked? " + this.tabularResource.isLocked());
            if (this.tabularResource.isLocked()) {
                throw new TabularResourceLockedException("tabular resource " + this.tabularResource.getName() + " is locked by another task");
            }
            this.tabularResource.lock();
            this.entityManager.merge((Object)this.tabularResource);
            this.entityManager.getTransaction().commit();
        }
        catch (RollbackException re) {
            logger.error("error on transaction code", (Throwable)re);
            this.entityManager.close();
            throw re;
        }
        catch (DatabaseException de) {
            logger.error("database error code is " + de.getDatabaseErrorCode(), (Throwable)de);
            this.entityManager.close();
            throw de;
        }
        catch (RuntimeException e) {
            logger.error("error on transaction code", (Throwable)e);
            this.entityManager.getTransaction().rollback();
            this.entityManager.close();
            throw e;
        }
    }

    public void abort() {
        if (this.taskHandler != null) {
            this.taskHandler.abort();
        }
        Statement stmt = StatementContainer.get((String)this.threadGroupName);
        logger.info("searching for thread group " + this.threadGroupName + " and statement is null? " + (stmt == null));
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.cancel();
            }
        }
        catch (Exception e) {
            logger.warn("the query cannot be aborted", (Throwable)e);
        }
        this.aborted = true;
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public StorableTask getTask() {
        return this.task;
    }

    public void registerOnSuccessEvent(RunnableTask event) {
        this.onSuccessEvent = event;
    }

    @Override
    public void run() {
        boolean tabularResourceValidity = this.tabularResource.isValid();
        this.threadGroupName = Thread.currentThread().getThreadGroup().getName();
        logger.info("saved thread group is " + this.threadGroupName);
        TabularResourceDescriptor descriptor = new TabularResourceDescriptor(this.tabularResource.getName(), this.tabularResource.getVersion(), this.tabularResource.getId());
        try {
            RollbackWorkerCreator workerCreator = this.task.getTaskType() == TaskInfo.TaskType.ROLLBACK ? new RollbackWorkerCreator() : new OperationWorkerCreator();
            this.initialize();
            if (this.aborted) {
                throw new OperationAbortedException();
            }
            this.taskHandler = new TaskHandler(this.cubeManager, this.taskContext, (WorkerCreator)workerCreator, descriptor, this.operationUtil, this.connectionProvider);
            tabularResourceValidity = this.taskHandler.run(this.executionHolder);
            if (this.aborted) {
                throw new OperationAbortedException();
            }
            this.tabularResource.setTableId(Long.valueOf(this.taskContext.getCurrentTable().getValue()));
            Table table = this.cubeManager.getTable(this.taskContext.getCurrentTable());
            this.tabularResource.setTableType(table.getTableType().getName());
            if (this.parallelizableExecution) {
                this.updateReferencedTabularResource();
            }
            this.onSuccess(this.taskHandler.isStopped());
        }
        catch (WorkerException we) {
            logger.error("error executing operation", (Throwable)we);
            this.onError(we);
        }
        catch (OperationAbortedException e) {
            logger.warn("operation aborted");
            this.onAbort();
        }
        catch (Throwable tb) {
            logger.error("unexpected error", tb);
            this.onError(new WorkerException("unexpected error executing operation", tb));
        }
        try {
            this.persistTabularResourceOnTaskFinished(tabularResourceValidity);
        }
        finally {
            try {
                this.entityManager.getTransaction().begin();
                this.tabularResource.unlock();
                this.entityManager.merge((Object)this.tabularResource);
                this.entityManager.getTransaction().commit();
            }
            catch (RollbackException re) {
                logger.error("error on transaction code", (Throwable)re);
                throw re;
            }
            catch (DatabaseException de) {
                logger.error("database error code is " + de.getDatabaseErrorCode(), (Throwable)de);
                throw de;
            }
            catch (RuntimeException e) {
                logger.error("error on transaction code", (Throwable)e);
                this.entityManager.getTransaction().rollback();
            }
            this.entityManager.close();
            StatementContainer.reset();
            TableContainer.reset();
        }
    }

    private void initialize() throws WorkerException {
        this.initializing();
        TaskInfo taskInfo = this.task.getStoredTask();
        taskInfo.setStartTime(Calendar.getInstance());
        this.task.setStoredTask(taskInfo);
        try {
            this.storeEntities();
            this.tableInitializer();
        }
        catch (Exception we) {
            throw new WorkerException("erorr initializing task", (Throwable)we);
        }
        this.inProgress();
    }

    private void tableInitializer() throws Exception {
        TableId startingTableId = null;
        if (this.tabularResource.getTableId() != null) {
            startingTableId = new TableId(this.tabularResource.getTableId().longValue());
        }
        this.taskContext.setStartingTable(startingTableId);
        this.taskContext.setCurrentTable(startingTableId);
    }

    private void storeEntities() throws Exception {
        try {
            this.entityManager.getTransaction().begin();
            this.tabularResource = (StorableTabularResource)this.entityManager.merge((Object)this.tabularResource);
            this.entityManager.persist((Object)this.taskContext);
            if (!this.resumedExecution) {
                this.entityManager.persist((Object)this.task);
                this.tabularResource.addTask(this.task);
            }
            this.entityManager.merge((Object)this.tabularResource);
            this.entityManager.getTransaction().commit();
        }
        catch (RollbackException re) {
            logger.error("error on transaction code", (Throwable)re);
            throw re;
        }
        catch (DatabaseException de) {
            logger.error("database error code is " + de.getDatabaseErrorCode(), (Throwable)de);
            throw de;
        }
        catch (RuntimeException e) {
            logger.error("error on transaction code", (Throwable)e);
            this.entityManager.getTransaction().rollback();
        }
    }

    private void updateReferencedTabularResource() {
        Table table = this.cubeManager.getTable(this.taskContext.getCurrentTable());
        try {
            this.entityManager.getTransaction().begin();
            ArrayList<RelationLink> links = new ArrayList<RelationLink>();
            for (TableRelationship relationship : table.getCodelistRelationships()) {
                Table externalReferenceTable = this.cubeManager.getTable(relationship.getTargetTableId());
                if (externalReferenceTable.contains(TableDescriptorMetadata.class)) {
                    StorableTabularResource externalTR = (StorableTabularResource)this.entityManager.find(StorableTabularResource.class, (Object)((TableDescriptorMetadata)externalReferenceTable.getMetadata(TableDescriptorMetadata.class)).getRefId());
                    RelationLink relationLink = (RelationLink)this.entityManager.find(RelationLink.class, (Object)new ColumnId(this.tabularResource.getId(), relationship.getTargetColumnId().getValue()));
                    if (relationLink != null) {
                        relationLink.setLinksToTabularResource(externalTR);
                        this.entityManager.merge((Object)relationLink);
                    } else {
                        relationLink = new RelationLink(this.tabularResource, relationship.getTargetColumnId().getValue(), externalTR);
                        logger.info("linked is null?? " + (relationLink.getLinkedTabularResource() == null));
                        logger.info("links to is null?? " + (relationLink.getLinksToTabulaResource() == null));
                        logger.info("column ID?? " + (relationLink.getColumnLocalId() == null));
                        this.entityManager.persist((Object)relationLink);
                    }
                    links.add(relationLink);
                    continue;
                }
                logger.warn("no table descriptor metadata found for table " + externalReferenceTable.getId());
            }
            for (RelationLink oldRl : this.tabularResource.getLinksTo()) {
                if (links.contains(oldRl)) continue;
                this.entityManager.remove((Object)oldRl);
            }
            this.tabularResource.setLinksTo(links);
            logger.trace("links to set: " + links);
            this.entityManager.merge((Object)this.tabularResource);
            this.entityManager.getTransaction().commit();
        }
        catch (RollbackException re) {
            logger.error("error on transaction code", (Throwable)re);
            throw re;
        }
        catch (DatabaseException de) {
            logger.error("database error code is " + de.getDatabaseErrorCode(), (Throwable)de);
            throw de;
        }
        catch (RuntimeException e) {
            logger.error("error on transaction code", (Throwable)e);
            this.entityManager.getTransaction().rollback();
        }
    }

    private void failureProcedure() {
        if (TableContainer.get((String)this.threadGroupName) != null) {
            this.garbageCollector.addTablesToRemove(TableContainer.get((String)this.threadGroupName));
        }
        this.tabularResource.setTableId(this.taskContext.getStartingTable() != null ? Long.valueOf(this.taskContext.getStartingTable().getValue()) : null);
    }

    void onError(WorkerException we) {
        this.failureProcedure();
        this.failed((Throwable)we);
    }

    void onAbort() {
        this.failureProcedure();
        this.aborted();
    }

    void onSuccess(boolean stopped) {
        this.historyModifications(this.executionHolder.getStepsToAddOnSuccess());
        this.garbageCollector.addTablesToRemove(this.executionHolder.getToRemoveOnFinish());
        this.assignReadOnlyRightOnDB(this.taskContext.getCurrentTable());
        if (!stopped) {
            Table table = this.cubeManager.removeValidations(this.taskContext.getCurrentTable());
            if (table.contains(DatasetViewTableMetadata.class)) {
                this.cubeManager.removeValidations(((DatasetViewTableMetadata)table.getMetadata(DatasetViewTableMetadata.class)).getTargetDatasetViewTableId());
            }
            this.success(table, this.createCollateralResource(this.executionHolder.getCreatedResources()));
        } else {
            this.stopped(this.cubeManager.getTable(this.taskContext.getCurrentTable()));
        }
    }

    private void assignReadOnlyRightOnDB(TableId currentTableId) {
        Table table = this.cubeManager.getTable(currentTableId);
        try {
            SQLHelper.executeSQLCommand((String)("GRANT SELECT ON TABLE " + table.getName() + " TO readonly"), (DatabaseConnectionProvider)this.connectionProvider);
            if (table.contains(DatasetViewTableMetadata.class)) {
                TableId viewId = ((DatasetViewTableMetadata)table.getMetadata(DatasetViewTableMetadata.class)).getTargetDatasetViewTableId();
                Table view = this.cubeManager.getTable(viewId);
                SQLHelper.executeSQLCommand((String)("GRANT SELECT ON TABLE " + view.getName() + " TO readonly"), (DatabaseConnectionProvider)this.connectionProvider);
            }
        }
        catch (Exception e) {
            logger.error("error assigning right to readonly for table " + currentTableId);
        }
    }

    private List<TableId> createCollateralResource(List<ExecutionHolder.ResourceHolder> createdResources) {
        int index = 0;
        ArrayList<TableId> collateralTablesCreated = new ArrayList<TableId>();
        for (ExecutionHolder.ResourceHolder res : createdResources) {
            if (res.getResourceDescriptor().getResource().getResourceType().equals(TableResource.class)) {
                ResourceDescriptorResult resourceDescriptor = res.getResourceDescriptor();
                String resourceName = resourceDescriptor.getName() == null ? String.valueOf(this.tabularResource.getName()) + "(collateral-" + index + ")" : resourceDescriptor.getName();
                this.tableResourceEvent.fire((Object)new ResourceCreated((TableResource)resourceDescriptor.getResource(), resourceName, this.task.getStoredTask().getSubmitter()));
                collateralTablesCreated.add(((TableResource)resourceDescriptor.getResource()).getTableId());
                continue;
            }
            StorableResource sr = new StorableResource(res.getResourceDescriptor().getName(), res.getResourceDescriptor().getDescription(), res.getResourceDescriptor().getResourceType(), res.getCreatorId(), res.getResourceDescriptor().getResource());
            this.tabularResource.addResource(sr);
            sr.setTabularResource(this.tabularResource);
            try {
                this.entityManager.getTransaction().begin();
                this.entityManager.persist((Object)sr);
                this.entityManager.merge((Object)this.tabularResource);
                this.entityManager.getTransaction().commit();
            }
            catch (RollbackException re) {
                logger.error("error on transaction code", (Throwable)re);
                throw re;
            }
            catch (DatabaseException de) {
                logger.error("database error code is " + de.getDatabaseErrorCode(), (Throwable)de);
                throw de;
            }
            catch (RuntimeException e) {
                logger.error("error on transaction code", (Throwable)e);
                this.entityManager.getTransaction().rollback();
            }
        }
        if (collateralTablesCreated.size() > 0) {
            logger.info(String.valueOf(this.taskContext.getCurrentInvocation().getWorkerFactory().getOperationDescriptor().getName()) + " has generated " + collateralTablesCreated);
        }
        return collateralTablesCreated;
    }

    private void historyModifications(List<StorableHistoryStep> historyStepsToAdd) {
        logger.debug("history steps to add are " + historyStepsToAdd.size());
        if (this.task.getStoredTask().getType() == TaskInfo.TaskType.ROLLBACK) {
            RollbackTaskInfo rollbackTask = (RollbackTaskInfo)this.task.getStoredTask();
            for (Long stepId : rollbackTask.getHistoryStepsToRemove()) {
                StorableHistoryStep step = (StorableHistoryStep)this.entityManager.find(StorableHistoryStep.class, (Object)stepId);
                step.getTabularResources().remove(this.tabularResource);
                this.tabularResource.removeHistoryStep(step);
            }
        } else {
            try {
                this.entityManager.getTransaction().begin();
                for (StorableHistoryStep step : historyStepsToAdd) {
                    logger.debug("adding history " + step);
                    step.addTabularResource(this.tabularResource);
                    this.entityManager.persist((Object)step);
                }
                this.tabularResource.addHistorySteps(historyStepsToAdd);
                this.entityManager.merge((Object)this.tabularResource);
                this.entityManager.getTransaction().commit();
            }
            catch (RollbackException re) {
                logger.error("error on transaction code", (Throwable)re);
                throw re;
            }
            catch (DatabaseException de) {
                logger.error("database error code is " + de.getDatabaseErrorCode(), (Throwable)de);
                throw de;
            }
            catch (RuntimeException e) {
                logger.error("error on transaction code", (Throwable)e);
                this.entityManager.getTransaction().rollback();
            }
        }
    }

    private void persistTabularResourceOnTaskFinished(boolean tabularResourceValidity) {
        this.tabularResource.setValid(tabularResourceValidity);
        try {
            this.entityManager.getTransaction().begin();
            this.entityManager.merge((Object)this.tabularResource);
            this.entityManager.merge((Object)this.taskContext);
            this.entityManager.merge((Object)this.task);
            this.entityManager.getTransaction().commit();
        }
        catch (RollbackException re) {
            logger.error("error on transaction code", (Throwable)re);
            throw re;
        }
        catch (DatabaseException de) {
            logger.error("database error code is " + de.getDatabaseErrorCode(), (Throwable)de);
            throw de;
        }
        catch (RuntimeException e) {
            logger.error("error on transaction code", (Throwable)e);
            this.entityManager.getTransaction().rollback();
        }
    }

    private void failed(Throwable cause) {
        logger.error("error executing task", cause);
        TaskInfo info = this.task.getStoredTask();
        info.setEndTime(Calendar.getInstance());
        info.setStatus(TaskStatus.FAILED);
        Exception exc = new Exception(String.valueOf(cause.getClass().getSimpleName()) + ": " + cause.getMessage());
        exc.setStackTrace(cause.getStackTrace());
        info.setErrorCause((Throwable)exc);
        this.task.setStoredTask(info);
    }

    private void stopped(Table table) {
        logger.error("stopping execution");
        TaskInfo info = this.task.getStoredTask();
        info.setEndTime(Calendar.getInstance());
        info.setStatus(TaskStatus.STOPPED);
        info.setResult(new WorkerResult(table));
        this.task.setStoredTask(info);
    }

    private void aborted() {
        logger.error("task aborted");
        TaskInfo info = this.task.getStoredTask();
        info.setEndTime(Calendar.getInstance());
        info.setStatus(TaskStatus.ABORTED);
        this.task.setStoredTask(info);
    }

    private void success(Table result, List<TableId> collateralTables) {
        TaskInfo info = this.task.getStoredTask();
        WorkerResult res = new WorkerResult(result, collateralTables);
        logger.info("collateral resource in the Result are " + res.getCollateralTables());
        info.setResult(res);
        info.setEndTime(Calendar.getInstance());
        try {
            if (this.onSuccessEvent != null) {
                this.onSuccessEvent.run(result);
            }
        }
        catch (Exception e) {
            logger.warn("on success event not executed");
        }
        info.setStatus(TaskStatus.SUCCEDED);
        this.task.setStoredTask(info);
    }

    private void inProgress() {
        TaskInfo info = this.task.getStoredTask();
        info.setStatus(TaskStatus.IN_PROGRESS);
        this.task.setStoredTask(info);
    }

    private void initializing() {
        TaskInfo info = this.task.getStoredTask();
        info.setStatus(TaskStatus.INITIALIZING);
        this.task.setStoredTask(info);
    }
}

