/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.task.executor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.data.analysis.tabulardata.metadata.StorableHistoryStep;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.task.executor.ExecutionHolder;
import org.gcube.data.analysis.tabulardata.utils.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionHolder {
    private Logger logger = LoggerFactory.getLogger(ExecutionHolder.class);
    private Set<TableId> toRemoveOnFinish = new HashSet();
    private List<StorableHistoryStep> stepsToAddOnSuccess = new ArrayList();
    private List<ResourceHolder> createdResources = new ArrayList();
    private Map<String, ColumnLocalId> createdColumnMapping = new HashMap();

    public void removeOnFinish(TableId tableId) {
        this.logger.trace("added to RemoveOnFinish " + tableId);
        this.toRemoveOnFinish.add(tableId);
    }

    public void addCreatedResource(ResourceHolder resource) {
        this.createdResources.add(resource);
    }

    public void createStep(WorkerFactory<?> factory, OperationInvocation sourceInvocation, WorkerResult finalResult, TableId tableBeforeOperationId) {
        StorableHistoryStep step;
        String operationDescription = factory.getOperationDescriptor().getDescription();
        try {
            operationDescription = factory.describeInvocation(sourceInvocation);
        }
        catch (Exception e) {
            this.logger.warn("operation description not found");
        }
        if (factory.isRollbackable() && finalResult.getDiffTable() != null) {
            step = new StorableHistoryStep(Long.valueOf(finalResult.getDiffTable().getId().getValue()), Util.toOperationExecution((OperationInvocation)sourceInvocation), operationDescription);
            step.setContainsDiff(true);
        } else {
            step = new StorableHistoryStep(tableBeforeOperationId == null ? null : Long.valueOf(tableBeforeOperationId.getValue()), Util.toOperationExecution((OperationInvocation)sourceInvocation), operationDescription);
        }
        this.stepsToAddOnSuccess.add(step);
    }

    protected Set<TableId> getToRemoveOnFinish() {
        return this.toRemoveOnFinish;
    }

    protected List<StorableHistoryStep> getStepsToAddOnSuccess() {
        return this.stepsToAddOnSuccess;
    }

    protected List<ResourceHolder> getCreatedResources() {
        return this.createdResources;
    }

    public void addColumnCreatedMapping(String invocationId, ColumnLocalId columnId) {
        this.createdColumnMapping.put(invocationId, columnId);
    }

    public ColumnLocalId getColumnCorrespondance(String invocationId) {
        return (ColumnLocalId)this.createdColumnMapping.get(invocationId);
    }

    public boolean areNewColumnsBeenCreated() {
        return !this.createdColumnMapping.isEmpty();
    }
}

