/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.commons.rules.ColumnRule;
import org.gcube.data.analysis.tabulardata.commons.rules.Rule;
import org.gcube.data.analysis.tabulardata.commons.rules.RuleScope;
import org.gcube.data.analysis.tabulardata.commons.rules.TableRule;
import org.gcube.data.analysis.tabulardata.commons.rules.types.BaseColumnRuleType;
import org.gcube.data.analysis.tabulardata.commons.rules.types.RuleTableType;
import org.gcube.data.analysis.tabulardata.commons.rules.types.RuleType;
import org.gcube.data.analysis.tabulardata.commons.utils.SharingEntity;
import org.gcube.data.analysis.tabulardata.commons.webservice.RuleManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchRuleException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.AppliedRulesResponse;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.MapObject;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.OnRowErrorAction;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.RuleDescription;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.gcube.data.analysis.tabulardata.exceptions.NoSuchObjectException;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.metadata.StorableRule;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.RuleMapping;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.StorableTabularResource;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.rules.AddRuleFinalActionFactory;
import org.gcube.data.analysis.tabulardata.service.SharingHelper;
import org.gcube.data.analysis.tabulardata.task.RunnableTask;
import org.gcube.data.analysis.tabulardata.task.TaskContext;
import org.gcube.data.analysis.tabulardata.task.engine.TaskEngine;
import org.gcube.data.analysis.tabulardata.utils.EntityManagerHelper;
import org.gcube.data.analysis.tabulardata.utils.OperationUtil;
import org.gcube.data.analysis.tabulardata.utils.Util;
import org.gcube.data.analysis.tabulardata.weld.WeldService;
import org.slf4j.Logger;

@WebService(portName="RuleManagerPort", serviceName="rulemanager", targetNamespace="http://gcube-system.org/rule", endpointInterface="org.gcube.data.analysis.tabulardata.commons.webservice.RuleManager")
@Singleton
@WeldService
public class RuleManagerImpl
implements RuleManager {
    @Inject
    private Logger logger;
    @Inject
    private EntityManagerHelper emHelper;
    @Inject
    private TaskEngine taskEngine;
    @Inject
    private OperationUtil opUtil;
    @Inject
    private AddRuleFinalActionFactory addRuleFinalActionFactory;

    public List<RuleDescription> getRules() throws InternalSecurityException {
        this.logger.info("getRules called");
        HashMap<String, String> parameters = new HashMap<String, String>(3);
        parameters.put("user", AuthorizationProvider.instance.get().getClient().getId());
        parameters.put("group", ScopeProvider.instance.get());
        parameters.put("scope", ScopeProvider.instance.get());
        List rules = this.emHelper.getResults("RULE.getAll", StorableRule.class, parameters);
        ArrayList<RuleDescription> descriptions = new ArrayList<RuleDescription>();
        for (StorableRule stRule : rules) {
            descriptions.add(Util.toRuleDescription((StorableRule)stRule));
        }
        return descriptions;
    }

    public List<RuleDescription> getRulesByScope(RuleScope scope) throws InternalSecurityException {
        this.logger.info("getRulesByScope with scope " + scope.name() + " called");
        HashMap<String, String> parameters = new HashMap<String, String>(4);
        parameters.put("user", AuthorizationProvider.instance.get().getClient().getId());
        parameters.put("group", ScopeProvider.instance.get());
        parameters.put("scope", ScopeProvider.instance.get());
        parameters.put("ruleScope", (String)scope);
        List rules = this.emHelper.getResults("RULE.getAllByScope", StorableRule.class, parameters);
        ArrayList<RuleDescription> descriptions = new ArrayList<RuleDescription>();
        for (StorableRule stRule : rules) {
            descriptions.add(Util.toRuleDescription((StorableRule)stRule));
        }
        return descriptions;
    }

    public List<RuleDescription> getApplicableBaseColumnRules(Class<? extends DataType> dataTypeClass) throws InternalSecurityException {
        this.logger.info("getApplyableColumnRules for datatype " + dataTypeClass.getSimpleName());
        HashMap<String, String> parameters = new HashMap<String, String>(4);
        parameters.put("user", AuthorizationProvider.instance.get().getClient().getId());
        parameters.put("group", ScopeProvider.instance.get());
        parameters.put("scope", ScopeProvider.instance.get());
        parameters.put("ruleScope", (String)RuleScope.COLUMN);
        List rules = this.emHelper.getResults("RULE.getAllByScope", StorableRule.class, parameters);
        ArrayList<RuleDescription> descriptions = new ArrayList<RuleDescription>();
        for (StorableRule stRule : rules) {
            if (!(stRule.getRuleType() instanceof BaseColumnRuleType) || !((BaseColumnRuleType)stRule.getRuleType()).getInternalType().getClass().equals(dataTypeClass)) continue;
            descriptions.add(Util.toRuleDescription((StorableRule)stRule));
        }
        return descriptions;
    }

    public long saveRule(String name, String description, Expression rule, RuleType ruleType) throws InternalSecurityException {
        this.logger.info("saveColumnRule called with parameters : name " + name + ", description " + description + ", expression " + rule + ", columnType " + ruleType);
        if (name == null || description == null || rule == null || ruleType == null) {
            throw new RuntimeException("null value passed");
        }
        StorableRule stRule = ruleType instanceof RuleTableType ? new StorableRule(name, description, (Rule)new TableRule(rule, ((RuleTableType)ruleType).getInternalType()), AuthorizationProvider.instance.get().getClient().getId(), ruleType) : new StorableRule(name, description, (Rule)new ColumnRule(rule), AuthorizationProvider.instance.get().getClient().getId(), ruleType);
        stRule.addScope(ScopeProvider.instance.get());
        try (EntityManager em = this.emHelper.getEntityManager();){
            em.getTransaction().begin();
            em.persist((Object)stRule);
            em.getTransaction().commit();
        }
        return stRule.getId();
    }

    public void updateColumnRule(RuleDescription descriptor) throws InternalSecurityException, NoSuchRuleException {
        this.logger.info("updateColumnRule called with parameters : id " + descriptor.getId() + ", name " + descriptor.getName() + ", description " + descriptor.getDescription());
        try (EntityManager em = this.emHelper.getEntityManager();){
            StorableRule rule = null;
            try {
                rule = (StorableRule)Util.getOwnerhipAuthorizedObject((Object)descriptor.getId(), StorableRule.class, (EntityManager)em);
            }
            catch (NoSuchObjectException e) {
                this.logger.error("Rule with id " + descriptor.getId() + " not found");
                throw new NoSuchRuleException(descriptor.getId());
            }
            em.getTransaction().begin();
            if (rule.getRuleScope() != RuleScope.COLUMN) {
                throw new NoSuchRuleException(descriptor.getId());
            }
            rule.setName(descriptor.getName());
            rule.setDescription(descriptor.getDescription());
            em.merge((Object)rule);
            em.getTransaction().commit();
        }
    }

    public TaskInfo applyColumnRule(Long tabularResourceId, String columnId, List<Long> ruleIds) throws InternalSecurityException, NoSuchRuleException, NoSuchTabularResourceException {
        this.logger.info("applying column rules with id " + ruleIds + " on tabularResource " + tabularResourceId);
        try (EntityManager em = this.emHelper.getEntityManager();){
            StorableTabularResource tr = null;
            try {
                tr = (StorableTabularResource)Util.getUserAuthorizedObject((Object)tabularResourceId, StorableTabularResource.class, (EntityManager)em);
            }
            catch (NoSuchObjectException e) {
                this.logger.error("TabularResource with id " + tabularResourceId + " not found");
                throw new NoSuchTabularResourceException(tabularResourceId.longValue());
            }
            ArrayList<RuleMapping> ruleMappings = new ArrayList<RuleMapping>();
            for (long ruleId : ruleIds) {
                StorableRule rule = (StorableRule)em.find(StorableRule.class, (Object)ruleId);
                RuleMapping mapping = new RuleMapping(rule, columnId);
                if (tr.getRules().contains(mapping)) continue;
                ruleMappings.add(mapping);
            }
            if (ruleMappings.isEmpty()) {
                throw new RuntimeException("no new rules to apply");
            }
            TaskContext context = new TaskContext(Collections.singletonList(this.opUtil.getRulesInvocation(ruleMappings, tr.getTableId().longValue())), OnRowErrorAction.ASK);
            this.opUtil.addPostOperations(context);
            this.opUtil.addPostValidations(context, tr);
            TaskInfo taskInfo = this.taskEngine.createTask(AuthorizationProvider.instance.get().getClient().getId(), context, tr, (RunnableTask)this.addRuleFinalActionFactory.create(tr.getId(), ruleMappings));
            return taskInfo;
        }
    }

    public TaskInfo applyTableRule(Long tabularResourceId, MapObject<String, String> mappingPlaceholderIDToColumnId, Long ruleId) throws InternalSecurityException, NoSuchRuleException, NoSuchTabularResourceException {
        this.logger.info("applying table rule with id " + ruleId + " on tabularResource " + tabularResourceId);
        try (EntityManager em = this.emHelper.getEntityManager();){
            StorableTabularResource tr = null;
            try {
                tr = (StorableTabularResource)Util.getUserAuthorizedObject((Object)tabularResourceId, StorableTabularResource.class, (EntityManager)em);
            }
            catch (NoSuchObjectException e) {
                this.logger.error("TabularResource with id " + tabularResourceId + " not found");
                throw new NoSuchTabularResourceException(tabularResourceId.longValue());
            }
            StorableRule rule = (StorableRule)em.find(StorableRule.class, (Object)ruleId);
            RuleMapping mapping = new RuleMapping(rule, mappingPlaceholderIDToColumnId.getMap());
            TaskContext context = new TaskContext(Collections.singletonList(this.opUtil.getRulesInvocation(Collections.singletonList(mapping), tr.getTableId().longValue())), OnRowErrorAction.ASK);
            this.opUtil.addPostOperations(context);
            this.opUtil.addPostValidations(context, tr);
            TaskInfo taskInfo = this.taskEngine.createTask(AuthorizationProvider.instance.get().getClient().getId(), context, tr, (RunnableTask)this.addRuleFinalActionFactory.create(tr.getId(), Collections.singletonList(mapping)));
            return taskInfo;
        }
    }

    public void detachColumnRules(Long tabularResourceId, String columnId, List<Long> ruleIds) throws InternalSecurityException, NoSuchTabularResourceException {
        this.logger.info("detaching column rules with id " + ruleIds + " on tabularResource " + tabularResourceId);
        try (EntityManager em = this.emHelper.getEntityManager();){
            StorableTabularResource tr = null;
            try {
                tr = (StorableTabularResource)Util.getOwnerhipAuthorizedObject((Object)tabularResourceId, StorableTabularResource.class, (EntityManager)em);
            }
            catch (NoSuchObjectException e) {
                this.logger.error("TabularResource with id " + tabularResourceId + " not found");
                throw new NoSuchTabularResourceException(tabularResourceId.longValue());
            }
            List descriptions = (List)this.getAppliedRulesByTabularResourceId(tabularResourceId).getColumnRuleMapping().get(columnId);
            if (descriptions != null) {
                em.getTransaction().begin();
                for (RuleDescription description : descriptions) {
                    if (!ruleIds.contains(description.getId())) continue;
                    tr.removeColumnRuleMapping(description.getId(), columnId);
                    em.merge((Object)tr);
                }
                em.getTransaction().commit();
            }
        }
    }

    public void detachTableRules(Long tabularResourceId, List<Long> ruleIds) throws InternalSecurityException, NoSuchTabularResourceException {
        this.logger.info("detaching table rules with id " + ruleIds + " on tabularResource " + tabularResourceId);
        try (EntityManager em = this.emHelper.getEntityManager();){
            StorableTabularResource tr = null;
            try {
                tr = (StorableTabularResource)Util.getOwnerhipAuthorizedObject((Object)tabularResourceId, StorableTabularResource.class, (EntityManager)em);
            }
            catch (NoSuchObjectException e) {
                this.logger.error("TabularResource with id " + tabularResourceId + " not found");
                throw new NoSuchTabularResourceException(tabularResourceId.longValue());
            }
            List descriptions = this.getAppliedRulesByTabularResourceId(tabularResourceId).getTableRules();
            if (descriptions != null) {
                em.getTransaction().begin();
                for (RuleDescription description : descriptions) {
                    if (!ruleIds.contains(description.getId())) continue;
                    tr.removeTableRuleMapping(description.getId());
                    em.merge((Object)tr);
                }
                em.getTransaction().commit();
            }
        }
    }

    public AppliedRulesResponse getAppliedRulesByTabularResourceId(Long id) throws NoSuchTabularResourceException, InternalSecurityException {
        EntityManager em = this.emHelper.getEntityManager();
        ArrayList<RuleDescription> tableRules = new ArrayList<RuleDescription>();
        HashMap columnRules = new HashMap();
        try {
            try {
                StorableTabularResource str = (StorableTabularResource)Util.getUserAuthorizedObject((Object)id, StorableTabularResource.class, (EntityManager)em);
                for (RuleMapping mapping : str.getRules()) {
                    StorableRule rule = mapping.getStorableRule();
                    RuleDescription descriptor = Util.toRuleDescription((StorableRule)rule);
                    if (mapping.getColumnLocalId() == null) {
                        tableRules.add(descriptor);
                        continue;
                    }
                    if (!columnRules.containsKey(mapping.getColumnLocalId())) {
                        columnRules.put(mapping.getColumnLocalId(), new ArrayList());
                    }
                    ((List)columnRules.get(mapping.getColumnLocalId())).add(descriptor);
                }
            }
            catch (NoSuchObjectException e) {
                throw new NoSuchTabularResourceException(id.longValue());
            }
        }
        finally {
            em.close();
        }
        return new AppliedRulesResponse(tableRules, columnRules);
    }

    public void remove(Long id) throws InternalSecurityException, NoSuchRuleException {
        this.logger.info("deleting column rule with id " + id);
        try (EntityManager em = this.emHelper.getEntityManager();){
            StorableRule rule;
            try {
                rule = (StorableRule)Util.getOwnerhipAuthorizedObject((Object)id, StorableRule.class, (EntityManager)em);
            }
            catch (NoSuchObjectException e) {
                this.logger.error("Rule with id " + id + " not found");
                throw new NoSuchRuleException(id.longValue());
            }
            em.getTransaction().begin();
            if (rule.getRuleMappings().isEmpty()) {
                this.logger.trace("ruleMappings for rule " + rule.getId() + " is empty");
                em.remove((Object)rule);
            } else {
                rule.setDeleted(true);
                em.merge((Object)rule);
            }
            em.getTransaction().commit();
        }
    }

    public RuleDescription share(Long entityId, SharingEntity ... entities) throws NoSuchRuleException, InternalSecurityException {
        try (EntityManager em = this.emHelper.getEntityManager();){
            StorableRule str = (StorableRule)SharingHelper.share(StorableRule.class, (Object)entityId, (EntityManager)em, (SharingEntity[])entities);
            RuleDescription ruleDescription = Util.toRuleDescription((StorableRule)str);
            return ruleDescription;
        }
    }

    public RuleDescription unshare(Long entityId, SharingEntity ... entities) throws NoSuchRuleException, InternalSecurityException {
        try (EntityManager em = this.emHelper.getEntityManager();){
            RuleDescription ruleDescription = Util.toRuleDescription((StorableRule)((StorableRule)SharingHelper.unshare(StorableRule.class, (Object)entityId, (EntityManager)em, (SharingEntity[])entities)));
            return ruleDescription;
        }
    }
}

