/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.metadata.tabularresource;

import java.util.Map;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import org.gcube.data.analysis.tabulardata.metadata.StorableRule;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.StorableTabularResource;

@Entity
public class RuleMapping {
    @Column
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected long id;
    @ElementCollection
    private Map<String, String> placeholderColumnMapping;
    @ManyToOne
    private StorableRule rule;
    @ManyToOne
    private StorableTabularResource tabularResource;
    @Column(nullable=true)
    private String columnLocalId;

    private RuleMapping() {
    }

    public RuleMapping(StorableRule rule, Map<String, String> placeholderColumnMapping) {
        this.rule = rule;
        this.placeholderColumnMapping = placeholderColumnMapping;
    }

    public RuleMapping(StorableRule rule, String columnLocalId) {
        this.rule = rule;
        this.columnLocalId = columnLocalId;
    }

    public StorableRule getStorableRule() {
        return this.rule;
    }

    public Map<String, String> getPlaceholderColumnMapping() {
        return this.placeholderColumnMapping;
    }

    public long getId() {
        return this.id;
    }

    public String getColumnLocalId() {
        return this.columnLocalId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnLocalId == null ? 0 : this.columnLocalId.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.placeholderColumnMapping == null ? 0 : this.placeholderColumnMapping.hashCode());
        result = 31 * result + (this.rule == null ? 0 : this.rule.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleMapping other = (RuleMapping)obj;
        if (this.rule.getId() != other.getStorableRule().getId()) {
            return false;
        }
        if (this.columnLocalId != null) {
            return this.columnLocalId.equals(other.columnLocalId);
        }
        return true;
    }
}

