/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.utils;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.utils.CDIProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalInvocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static Logger log = LoggerFactory.getLogger(InternalInvocation.class);
    private Map<String, Object> parameters;
    private transient WorkerFactory<?> workerFactory;
    private final String invocationId = UUID.randomUUID().toString();
    private long operationId;
    private ColumnLocalId columnId;
    private Table diffTable;
    private Map<String, ColumnLocalId> mappingColumnsPlaceholder = null;

    private InternalInvocation() {
    }

    public InternalInvocation(Map<String, Object> parameters, WorkerFactory<?> workerFactory) {
        this.parameters = parameters;
        this.workerFactory = workerFactory;
        if (workerFactory != null) {
            this.operationId = workerFactory.getOperationDescriptor().getOperationId().getValue();
            log.debug("saved operationID is " + this.operationId);
        }
        log.debug("is workerFacotry null ?  " + (workerFactory == null));
    }

    public InternalInvocation(Map<String, Object> parameters, WorkerFactory<?> workerFactory, Table diffTable) {
        this(parameters, workerFactory);
        this.diffTable = diffTable;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public ColumnLocalId getColumnId() {
        return this.columnId;
    }

    public String getInvocationId() {
        return this.invocationId;
    }

    public WorkerFactory<?> getWorkerFactory() {
        if (this.workerFactory == null) {
            log.debug("searching for workerFactory with ID " + this.operationId);
            log.debug("the factory map contains the ID? " + CDIProducer.getFactoryMap().containsKey(new OperationId(this.operationId)));
            this.workerFactory = CDIProducer.getFactoryMap().get(new OperationId(this.operationId));
        }
        return this.workerFactory;
    }

    public Map<String, ColumnLocalId> getMappingColumnsPlaceholder() {
        return this.mappingColumnsPlaceholder;
    }

    public void setMappingColumnsPlaceholder(Map<String, ColumnLocalId> mappingColumnsPlaceholder) {
        this.mappingColumnsPlaceholder = mappingColumnsPlaceholder;
    }

    public void setColumnId(ColumnLocalId columnId) {
        this.columnId = columnId;
    }

    public Table getDiffTable() {
        return this.diffTable;
    }

    public boolean isNop() {
        return false;
    }

    public String toString() {
        return "InternalInvocation [parameters=" + this.parameters + ", operationId=" + this.operationId + ", columnId=" + this.columnId + ", diffTableId=" + (this.diffTable != null ? this.diffTable.getId() : "not provided") + "]";
    }

    public static String getDinamicallyCreatedColumnId(String invocationId, int index) {
        return String.valueOf(invocationId) + ":" + index;
    }
}

