/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.utils;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TypedQuery;
import org.gcube.data.analysis.tabulardata.utils.TabularDataMetadata;

@Singleton
public class EntityManagerHelper {
    @Inject
    @TabularDataMetadata
    EntityManagerFactory emFactory;

    public EntityManager getEntityManager() {
        return this.emFactory.createEntityManager();
    }

    public <T> List<T> getResults(String queryName, Class<T> entityClass, Map<String, Object> parameters) {
        EntityManager em = this.emFactory.createEntityManager();
        TypedQuery query = em.createNamedQuery(queryName, entityClass);
        for (Map.Entry<String, Object> param : parameters.entrySet()) {
            query.setParameter(param.getKey(), param.getValue());
        }
        List descriptors = query.getResultList();
        if (em != null && em.isOpen()) {
            em.close();
        }
        return descriptors;
    }

    public <T> List<T> getResults(String queryName, Class<T> entityClass) {
        EntityManager em = this.emFactory.createEntityManager();
        TypedQuery query = em.createNamedQuery(queryName, entityClass);
        List descriptors = query.getResultList();
        if (em != null && em.isOpen()) {
            em.close();
        }
        return descriptors;
    }
}

