/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.task.executor.operation.creators;

import java.util.List;
import java.util.Observer;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.Result;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.gcube.data.analysis.tabulardata.task.TaskStepUpdater;
import org.gcube.data.analysis.tabulardata.task.ValidationStepUpdater;
import org.gcube.data.analysis.tabulardata.task.executor.ExecutionHolder;
import org.gcube.data.analysis.tabulardata.task.executor.operation.OperationContext;
import org.gcube.data.analysis.tabulardata.utils.InternalInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkerCreator {
    protected static Logger logger = LoggerFactory.getLogger(WorkerCreator.class);

    protected abstract Worker<?> create(InternalInvocation var1, OperationContext var2, ExecutionHolder var3) throws InvalidInvocationException;

    protected abstract List<ValidationWorker> discoveryPreconditions(InternalInvocation var1, OperationContext var2, ExecutionHolder var3) throws Exception;

    public abstract TableId resultCollector(ExecutionHolder var1, Result var2, OperationContext var3, OperationInvocation var4);

    public final Worker<?> getWorker(InternalInvocation invocation, OperationContext operationContext, ExecutionHolder executionHolder) throws InvalidInvocationException {
        Worker worker = this.create(invocation, operationContext, executionHolder);
        TaskStepUpdater updater = new TaskStepUpdater(operationContext.getTaskStep());
        worker.addObserver((Observer)updater);
        return worker;
    }

    public List<ValidationWorker> getPreconditions(InternalInvocation invocation, OperationContext operationContext, ExecutionHolder executionHolder) throws Exception {
        List preconditions = this.discoveryPreconditions(invocation, operationContext, executionHolder);
        if (!preconditions.isEmpty()) {
            List validationSteps = operationContext.getTaskStep().getValidationSteps();
            if (validationSteps.size() != preconditions.size()) {
                throw new Exception("error on preconditions");
            }
            for (int i = 0; i < preconditions.size(); ++i) {
                ((ValidationWorker)preconditions.get(i)).addObserver((Observer)((ValidationStepUpdater)validationSteps.get(i)));
            }
        }
        return preconditions;
    }
}

