/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Representable;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.ArgumentContainer;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.ArgumentDescriptor;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.ArgumentInstance;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.DependencyDescriptor;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.InstanceInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerInstance
implements InstanceInterface {
    private static final Logger log = LoggerFactory.getLogger(ContainerInstance.class);
    private String identifier = UUID.randomUUID().toString();
    private Map<String, ArgumentInstance<?>> argumentInstances = new LinkedHashMap();
    private Map<String, List<ContainerInstance>> containerInstances = new LinkedHashMap<String, List<ContainerInstance>>();
    private ArgumentContainer parentArgument;
    private ContainerInstance parentInstance = null;

    protected ContainerInstance(@NonNull ArgumentContainer parentArgument, ContainerInstance parentInstance) {
        if (parentArgument == null) {
            throw new NullPointerException("parentArgument");
        }
        this.parentArgument = parentArgument;
        this.parentInstance = parentInstance;
        this.createInstanceInternally();
    }

    public static InstanceInterface getChildInstanceById(ContainerInstance instance, String instanceToFindId) {
        for (ArgumentInstance<?> argumentInstance : instance.getAllArgumentInstances()) {
            if (!argumentInstance.getIdentifier().equals(instanceToFindId)) continue;
            return argumentInstance;
        }
        for (List list : instance.getContainerInstances().values()) {
            for (ContainerInstance contInst : list) {
                if (contInst.getIdentifier().equals(instanceToFindId)) {
                    return contInst;
                }
                InstanceInterface subInst = ContainerInstance.getChildInstanceById(contInst, instanceToFindId);
                if (subInst == null) continue;
                return subInst;
            }
        }
        return null;
    }

    public static List<ArgumentInstance<?>> getInstancesBydescriptorId(ContainerInstance instance, String descriptorId) {
        ArrayList argumentsInstances = new ArrayList();
        if (instance.getArgumentInstances().containsKey(descriptorId)) {
            argumentsInstances.add(instance.getArgumentInstances().get(descriptorId));
        }
        for (Map.Entry<String, List<ContainerInstance>> argCont : instance.getContainerInstances().entrySet()) {
            for (ContainerInstance contInst : argCont.getValue()) {
                argumentsInstances.addAll(ContainerInstance.getInstancesBydescriptorId(contInst, descriptorId));
            }
        }
        return argumentsInstances;
    }

    public static ContainerInstance createFirstInstance(ArgumentContainer argCont) {
        if (argCont.getParent() != null) {
            throw new IllegalArgumentException(String.valueOf(argCont.getIdentifier()) + " is not root");
        }
        ContainerInstance instance = new ContainerInstance(argCont, null);
        ContainerInstance.registerEventForContainer(instance, instance);
        return instance;
    }

    private static void registerEventForContainer(ContainerInstance root, ContainerInstance actual) {
        for (ArgumentInstance<?> argInstance : actual.getAllArgumentInstances()) {
            ContainerInstance.registersEvents(root, argInstance);
        }
        for (ContainerInstance contInstList : actual.getAllContainerInstances()) {
            ContainerInstance.registerEventForContainer(root, contInstList);
        }
    }

    public boolean canCopy() {
        int alreadyCreated = 0;
        if (this.getParentInstance().getContainerInstances().containsKey(this.parentArgument.getIdentifier())) {
            alreadyCreated = this.getParentInstance().getContainerInstances().get(this.parentArgument.getIdentifier()).size();
        }
        return this.parentArgument.getMaxInstances() > alreadyCreated;
    }

    public boolean canRemove() {
        int alreadyCreated = 0;
        if (this.getParentInstance().getContainerInstances().containsKey(this.parentArgument.getIdentifier())) {
            alreadyCreated = this.getParentInstance().getContainerInstances().get(this.parentArgument.getIdentifier()).size();
        }
        return this.parentArgument.getMinInstances() < alreadyCreated;
    }

    public void remove() {
        if (!this.canRemove()) {
            throw new IllegalStateException("this instance cannot be removed");
        }
        this.getParentInstance().getContainerInstances().get(this.getParentArgument().getIdentifier()).remove(this);
        ContainerInstance.setNotAliveInstances(this);
    }

    private static void setNotAliveInstances(ContainerInstance instance) {
        for (ArgumentInstance<?> argInst : instance.getAllArgumentInstances()) {
            argInst.setAlive(false);
        }
        for (ContainerInstance contInst : instance.getAllContainerInstances()) {
            ContainerInstance.setNotAliveInstances(contInst);
        }
    }

    public ContainerInstance createCopy() {
        ContainerInstance instance;
        if (!this.canCopy()) {
            throw new IllegalStateException("copy of this instance cannot be created");
        }
        ContainerInstance root = instance = this.getParentInstance().createInstanceOf(this.parentArgument);
        while (root.getParentInstance() != null) {
            root = root.getParentInstance();
        }
        for (ArgumentInstance<?> originalArgInst : this.getAllArgumentInstances()) {
            if (!originalArgInst.getParent().isDependsOnItself()) continue;
            List<ArgumentInstance<?>> copyArgInstances = ContainerInstance.getInstancesBydescriptorId(instance, originalArgInst.getParent().getIdentifier());
            for (ArgumentInstance<?> argInst : copyArgInstances) {
                argInst.setSelector(originalArgInst.getSelector());
            }
        }
        ContainerInstance.registerEventForContainer(root, instance);
        return instance;
    }

    private void createInstanceInternally() {
        for (ArgumentContainer argumentContainer : this.parentArgument.getContainers()) {
            this.createInstanceOf(argumentContainer);
        }
        for (ArgumentDescriptor argumentDescriptor : this.parentArgument.getArguments()) {
            this.createInstanceOf(argumentDescriptor);
        }
    }

    public Collection<ArgumentInstance<?>> getAllArgumentInstances() {
        return Collections.unmodifiableCollection(this.argumentInstances.values());
    }

    public Collection<ContainerInstance> getAllContainerInstances() {
        ArrayList<ContainerInstance> toReturn = new ArrayList<ContainerInstance>();
        for (List<ContainerInstance> contInstList : this.getContainerInstances().values()) {
            for (ContainerInstance inst : contInstList) {
                toReturn.add(inst);
            }
        }
        return toReturn;
    }

    protected <T extends Representable> ArgumentInstance<T> createInstanceOf(ArgumentDescriptor<T> argumentDescriptor) {
        if (!this.parentArgument.getArguments().contains(argumentDescriptor)) {
            throw new IllegalArgumentException("this container instance doesn't contain argumen descriptor " + argumentDescriptor.getName());
        }
        if (this.argumentInstances.containsKey(argumentDescriptor.getIdentifier())) {
            throw new IllegalArgumentException("instance for argument descriptor " + argumentDescriptor.getName() + " already created for this container");
        }
        ArgumentInstance<T> instance = argumentDescriptor.createInstance(this);
        this.argumentInstances.put(argumentDescriptor.getIdentifier(), instance);
        log.trace("creating instance for " + argumentDescriptor.getName());
        return instance;
    }

    private static void registersEvents(ContainerInstance rootInstance, ArgumentInstance<?> instance) {
        log.trace("rootInstance is " + rootInstance.getIdentifier());
        if (!instance.getParent().getDependsOnArguments().isEmpty()) {
            for (DependencyDescriptor dependsOnDescriptor : instance.getParent().getDependsOnArguments()) {
                List<ArgumentInstance<?>> dependsOnInstances = ContainerInstance.getInstancesBydescriptorId(rootInstance, dependsOnDescriptor.getDependencyId());
                for (ArgumentInstance<?> dependsOnInstance : dependsOnInstances) {
                    if (dependsOnInstance.getIdentifier().equals(instance.getIdentifier()) || dependsOnDescriptor.getDepType().equals((Object)DependencyDescriptor.DependencyType.LOCAL) && !dependsOnInstance.getContainerInstanceBelongsTo().getIdentifier().equals(instance.getContainerInstanceBelongsTo().getIdentifier())) continue;
                    dependsOnInstance.registerListener(instance);
                }
            }
        }
    }

    protected ContainerInstance createInstanceOf(ArgumentContainer argumentContainer) {
        if (!this.parentArgument.getContainers().contains(argumentContainer)) {
            throw new IllegalArgumentException("this container instance doesn't contain container descriptor " + argumentContainer.getIdentifier());
        }
        List<ContainerInstance> instancesAlreadyCreated = this.containerInstances.get(argumentContainer.getIdentifier());
        if (instancesAlreadyCreated != null && instancesAlreadyCreated.size() == argumentContainer.getMaxInstances()) {
            throw new IllegalArgumentException("max instances created reached for " + argumentContainer.getIdentifier());
        }
        ContainerInstance instance = argumentContainer.createinstance(this);
        log.trace("parent instance is " + instance.getParentInstance());
        if (this.containerInstances.containsKey(argumentContainer.getIdentifier())) {
            this.containerInstances.get(argumentContainer.getIdentifier()).add(instance);
        } else {
            ArrayList<ContainerInstance> list = new ArrayList<ContainerInstance>();
            list.add(instance);
            this.containerInstances.put(argumentContainer.getIdentifier(), list);
        }
        return instance;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String getDescription() {
        return this.parentArgument.getDescription();
    }

    @Override
    public String getName() {
        return this.parentArgument.getName();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    protected Map<String, ArgumentInstance<?>> getArgumentInstances() {
        return this.argumentInstances;
    }

    public Map<String, List<ContainerInstance>> getContainerInstances() {
        return this.containerInstances;
    }

    public ArgumentContainer getParentArgument() {
        return this.parentArgument;
    }

    private void setParentInstance(ContainerInstance parentInstance) {
        this.parentInstance = parentInstance;
    }

    public ContainerInstance getParentInstance() {
        return this.parentInstance;
    }
}

