/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model.columns;

import java.util.Arrays;
import java.util.List;
import org.gcube.data.analysis.tabulardata.commons.utils.DimensionReference;
import org.gcube.data.analysis.tabulardata.commons.utils.LocaleReference;
import org.gcube.data.analysis.tabulardata.commons.utils.TimeDimensionReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;

public enum ColumnCategory {
    ATTRIBUTE((ColumnType)new AttributeColumnType(), null, IntegerType.class, NumericType.class, TextType.class, DateType.class),
    DIMENSION((ColumnType)new DimensionColumnType(), DimensionReference.class, IntegerType.class),
    TIMEDIMENSION((ColumnType)new TimeDimensionColumnType(), TimeDimensionReference.class, IntegerType.class),
    MEASURE((ColumnType)new MeasureColumnType(), null, IntegerType.class, NumericType.class),
    CODENAME((ColumnType)new CodeNameColumnType(), LocaleReference.class, TextType.class),
    CODEDESCRIPTION((ColumnType)new CodeDescriptionColumnType(), null, TextType.class),
    ANNOTATION((ColumnType)new AnnotationColumnType(), null, TextType.class),
    CODE((ColumnType)new CodeColumnType(), null, TextType.class);

    private List<Class<? extends DataType>> classes;
    private boolean referenceRequired;
    private Class<?> referenceClass;
    private ColumnType modelType;

    private ColumnCategory(ColumnType modelType, Class<?> referenceClass, Class<? extends DataType> ... classes) {
        this.classes = Arrays.asList(classes);
        this.referenceRequired = referenceClass != null;
        this.referenceClass = referenceClass;
        this.modelType = modelType;
    }

    public List<Class<? extends DataType>> getAllowedClasses() {
        return this.classes;
    }

    public boolean isReferenceRequired() {
        return this.referenceRequired;
    }

    public Class<?> getReferenceClass() {
        return this.referenceClass;
    }

    public ColumnType getModelType() {
        return this.modelType;
    }
}

