
package org.gcube.data.analysis.tabulardata.commons.webservice.types;

import java.util.Calendar;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.table.TableId;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class HistoryData {

	@XmlElement
	private OperationExecution execution;
	
	@XmlElement
	private TableId resultTable;

	@XmlElement	
	private Calendar date;
	
	protected HistoryData(){}
	
	public HistoryData(OperationExecution execution, TableId resultTable, Calendar date) {
		super();
		this.execution = execution;
		this.resultTable = resultTable;
		this.date = date;
	}

	/**
	 * @return the invocation
	 */
	public OperationExecution getInvocation() {
		return execution;
	}
		
	/**
	 * @return the resultTable
	 */
	public TableId getResultTableId() {
		return resultTable;
	}

	
	
	/**
	 * @return the date
	 */
	public Calendar getDate() {
		return date;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "HistoryData [execution=" + execution + ", resultTable="
				+ resultTable + ", date=" + date.getTime() + "]";
	}


	

	
	
}
