/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model.columns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.commons.rules.ColumnRule;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TemplateColumn<T extends DataType> {
    private String id = UUID.randomUUID().toString();
    private ColumnCategory columnType;
    private Object reference;
    private List<ColumnRule> rules = new ArrayList<ColumnRule>();
    private Class<T> valueType;

    private TemplateColumn() {
    }

    public TemplateColumn(ColumnCategory columnType, Class<T> valueType) {
        if (!columnType.getAllowedClasses().contains(valueType)) {
            throw new IllegalArgumentException(String.format("valueType %s not allowed for column %s", new Object[]{valueType.getName(), columnType}));
        }
        this.columnType = columnType;
        this.valueType = valueType;
    }

    public TemplateColumn(ColumnCategory columnType, Class<T> valueType, Object reference) {
        if (!columnType.getAllowedClasses().contains(valueType)) {
            throw new IllegalArgumentException(String.format("valueType %s not allowed for column %s", valueType.getName(), this.getClass().getSimpleName()));
        }
        if (!columnType.isReferenceRequired() || reference == null || !reference.getClass().equals(columnType.getReferenceClass())) {
            throw new IllegalArgumentException(String.format("a valid reference is required", new Object[0]));
        }
        this.columnType = columnType;
        this.valueType = valueType;
        this.reference = reference;
    }

    public ColumnCategory getColumnType() {
        return this.columnType;
    }

    public Class<? extends DataType> getValueType() {
        return this.valueType;
    }

    public String getId() {
        return this.id;
    }

    public List<ColumnRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public void addRule(ColumnRule rule) {
        this.rules.add(rule);
    }

    public Object getReference() {
        return this.reference;
    }

    public String toString() {
        return "TemplateColumn [id=" + this.id + ", columnType=" + (Object)((Object)this.columnType) + ", rules=" + this.rules + ", valueType=" + this.valueType.getName() + "]";
    }
}

