package org.gcube.data.analysis.tabulardata.commons.templates.model.columns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.commons.rules.ColumnRule;
//import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.TemplateColumnAction;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class TemplateColumn<T extends DataType> {
	
	private String id = UUID.randomUUID().toString();
	
	private ColumnCategory columnType;
	
	private Object reference;
	
	private List<ColumnRule> rules = new ArrayList<ColumnRule>();
	
	private Class<T> valueType;
		
	@SuppressWarnings("unused")
	private TemplateColumn(){}
	
	public TemplateColumn(ColumnCategory columnType, Class<T> valueType){
		if (!columnType.getAllowedClasses().contains(valueType))
			throw new IllegalArgumentException(
					String.format("valueType %s not allowed for column %s", valueType.getName(), columnType));
		this.columnType = columnType;
		this.valueType = valueType;
	}
	
	public TemplateColumn(ColumnCategory columnType, Class<T> valueType, Object reference){
		if (!columnType.getAllowedClasses().contains(valueType))
			throw new IllegalArgumentException(
					String.format("valueType %s not allowed for column %s", valueType.getName(), this.getClass().getSimpleName()));
		if (!columnType.isReferenceRequired() || reference==null || !reference.getClass().equals(columnType.getReferenceClass()) )
			throw new IllegalArgumentException(
					String.format("a valid reference is required"));
		this.columnType = columnType;
		this.valueType = valueType;
		this.reference = reference;
	}

	/**
	 * @return the columnType
	 */
	public ColumnCategory getColumnType() {
		return columnType;
	}

	/**
	 * @return the valueType
	 */
	public Class<? extends DataType> getValueType() {
		return valueType;
	}
		
/*	public List<TemplateColumnAction> getActions() {
		return actions;
	}*/

/*	public void setActions(List<TemplateColumnAction> actions) {
		this.actions = actions;
	}*/

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}
	
	/**
	 * @return the rules
	 */
	public List<ColumnRule> getRules() {
		return Collections.unmodifiableList(rules);
	}

	public void addRule(ColumnRule rule){
		rules.add(rule);
	}

	
	/**
	 * @return the reference
	 */
	public Object getReference() {
		return reference;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "TemplateColumn [id=" + id + ", columnType=" + columnType
				+ ", rules=" + rules + ", valueType="
				+ valueType.getName() + "]";
	}
	
}
