package org.gcube.data.td.commons.webservice;

import java.util.List;
import java.util.UUID;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;
import javax.jws.soap.SOAPBinding.Style;
import javax.jws.soap.SOAPBinding.Use;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.td.commons.utils.Constants;
import org.gcube.data.td.commons.webservice.exception.InvalidInvocationException;
import org.gcube.data.td.commons.webservice.exception.NoSuchColumnException;
import org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.td.commons.webservice.exception.OperationNotFoundException;
import org.gcube.data.td.commons.webservice.types.TaskInfo;


@WebService(targetNamespace=Constants.TNS)
@SOAPBinding(style = Style.DOCUMENT, use=Use.LITERAL)
public interface OperationManager {
	
	public static final String SERVICE_NAME = "operationmanager";

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	public List<EligibleOperation> getCapabilities(Long tableId, UUID columnId) throws NoSuchTabularResourceException, NoSuchColumnException;

	
	/**
	 *  return the taskId
	 * 
	 * @param invocation
	 * @param targetTabularResourceId
	 * @return
	 * @throws NoSuchTabularResourceException
	 * @throws InvalidInvocationException
	 * @throws OperationNotFoundException 
	 */
	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	public TaskInfo execute(OperationInvocation invocation, long targetTabularResourceId) throws NoSuchTabularResourceException, InvalidInvocationException, OperationNotFoundException;
	
}
