package org.gcube.data.analysis.tabulardata.service;

import java.util.List;

import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.service.operation.OperationInterface;
import org.gcube.data.analysis.tabulardata.service.operation.OperationInterfaceMock;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.Task.TaskId;
import org.gcube.data.analysis.tabulardata.service.query.QueryInterface;
import org.gcube.data.analysis.tabulardata.service.query.QueryInterfaceMock;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceInterface;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceInterfaceMock;

public class TabularDataServiceMock implements TabularDataService {

	private QueryInterface queryInterface = new QueryInterfaceMock();

	private TabularResourceInterface tabularResourceInterface = new TabularResourceInterfaceMock();

	private OperationInterface operationInterface = new OperationInterfaceMock();

	@Override
	public Table getTable(TableId tableId) throws NoSuchTableException {
		return queryInterface.getTable(tableId);
	}

	@Override
	public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter, QueryOrder order)
			throws NoSuchTableException {
		return queryInterface.queryAsJson(tableId, page, filter, order);
	}

	@Override
	public int getQueryLenght(TableId tableId, QueryFilter filter) throws NoSuchTableException {
		return queryInterface.getQueryLenght(tableId, filter);
	}

	@Override
	public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter) throws NoSuchTableException {
		return queryInterface.queryAsJson(tableId, page, filter);
	}

	@Override
	public String queryAsJson(TableId tableId, QueryPage page, QueryOrder order) throws NoSuchTableException {
		return queryInterface.queryAsJson(tableId, page, order);
	}

	@Override
	public String queryAsJson(TableId tableId, QueryPage page) throws NoSuchTableException {
		return queryInterface.queryAsJson(tableId, page);
	}
	
	@Override
	public List<TabularResource> getTabularResources() {
		return tabularResourceInterface.getTabularResources();
	}
	
	@Override
	public TabularResource getTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
		return tabularResourceInterface.getTabularResource(id);
	}
	
	@Override
	public void removeTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
		tabularResourceInterface.removeTabularResource(id);
	}

	@Override
	public TabularResource cloneTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
		return tabularResourceInterface.cloneTabularResource(id);
	}

	@Override
	public TabularResource cloneTabularResource(TabularResourceId id, TableId lastTableId)
			throws NoSuchTabularResourceException, NoSuchTableException {
		return tabularResourceInterface.cloneTabularResource(id, lastTableId);
	}

	@Override
	public TabularResource createTabularResource() {
		return tabularResourceInterface.createTabularResource();
	}

	@Override
	public Table getLastTable(TabularResourceId id) throws NoSuchTabularResourceException,
			InvalidTabularResourceException {
		return tabularResourceInterface.getLastTable(id);
	}

	@Override
	public List<EligibleOperation> getCapabilities() {
		return operationInterface.getCapabilities();
	}

	@Override
	public List<EligibleOperation> getCapabilities(TabularResourceId tabularResourceId)
			throws NoSuchTabularResourceException, InvalidTabularResourceException {
		return operationInterface.getCapabilities(tabularResourceId);
	}

	@Override
	public List<EligibleOperation> getCapabilities(TabularResourceId tabularResourceId, ColumnLocalId columnId)
			throws NoSuchTabularResourceException, InvalidTabularResourceException, NoSuchColumnException {
		return operationInterface.getCapabilities(tabularResourceId, columnId);
	}

	@Override
	public Task execute(OperationInvocation invocation, TabularResourceId targetTabularResourceId)
			throws NoSuchTabularResourceException, InvalidTabularResourceException, InvalidInvocationException {
		return operationInterface.execute(invocation, targetTabularResourceId);
	}

	@Override
	public Table rollbackToTable(TabularResourceId tabularResourceId, TableId toTableId)
			throws NoSuchTabularResourceException, NoSuchTableException {
		return operationInterface.rollbackToTable(tabularResourceId, toTableId);
	}

	@Override
	public List<Task> getTasks(TabularResourceId tabularResourceId) throws NoSuchTabularResourceException {
		return operationInterface.getTasks(tabularResourceId);
	}

	@Override
	public Task getTask(TaskId operationId, TabularResourceId tabularResourceId) throws NoSuchTaskException,
			NoSuchTabularResourceException {
		return operationInterface.getTask(operationId, tabularResourceId);
	}

}
