package org.gcube.data.analysis.tabulardata.service.tabular;

import java.util.List;

import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.ServiceState;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.TabularResourceMetadata;

import com.google.common.collect.Lists;

public class TabularResourceInterfaceMock implements TabularResourceInterface {

	@Override
	public List<TabularResource> getTabularResources() {
		return ServiceState.tabularResources;
	}

	@Override
	public TabularResource getTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {

		for (TabularResource tabularResource : ServiceState.tabularResources) {
			if (id.equals(tabularResource.getId()))
				return tabularResource;
		}
		throw new NoSuchTabularResourceException(id);

	}

	@Override
	public void removeTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
		TabularResource toRemove = getTabularResource(id);
		ServiceState.tabularResources.remove(toRemove);
	}

	@Override
	public TabularResource cloneTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
		TabularResource tabularResourceToClone = getTabularResource(id);
		TabularResource newTabularResource = new ImmutableTabularResource(tabularResourceToClone);
		ServiceState.tabularResources.add(newTabularResource);
		return newTabularResource;
	}

	@Override
	public TabularResource cloneTabularResource(TabularResourceId id, TableId lastTableId)
			throws NoSuchTabularResourceException, NoSuchTableException {
		TabularResource tabularResourceToClone = getTabularResource(id);
		List<HistoryStep> newHistory = Lists.newArrayList();
		for (HistoryStep historyStep : newHistory) {
			if (historyStep.getResultTable().getId().equals(lastTableId)) {
				newHistory.add(historyStep);
				TabularResource result = new ImmutableTabularResource(newHistory, tabularResourceToClone
						.getAllMetadata());
				ServiceState.tabularResources.add(result);
				return result;
			} else
				newHistory.add(historyStep);
		}
		throw new NoSuchTableException(lastTableId);

	}

	@Override
	public TabularResource createTabularResource() {
		TabularResource newTabularResource = new ImmutableTabularResource();
		ServiceState.tabularResources.add(newTabularResource);
		return newTabularResource;
	}

}
