/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl.rules;

import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.RuleManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.rules.RuleScope;
import org.gcube.data.analysis.tabulardata.commons.rules.types.RuleColumnType;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchRuleException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.AppliedRulesResponse;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.RuleDescription;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskFactory;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.rules.RuleId;
import org.gcube.data.analysis.tabulardata.service.rules.RuleInterface;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;

public class RuleInterfaceImpl
implements RuleInterface {
    private RuleManagerProxy manager = (RuleManagerProxy)AbstractPlugin.rule().build();

    public RuleId saveColumnRule(String name, String description, Expression rule, RuleColumnType columnType) {
        return new RuleId(this.manager.saveColumnRule(name, description, rule, columnType));
    }

    public List<RuleDescription> getRules() {
        return this.manager.getRules();
    }

    public List<RuleDescription> getRulesByScope(RuleScope scope) {
        return this.manager.getRulesByScope(scope);
    }

    public void removeRuleById(RuleId id) throws NoSuchRuleException {
        this.manager.remove(Long.valueOf(id.getValue()));
    }

    public void updateColumnRule(RuleDescription descriptor) throws NoSuchRuleException {
        this.manager.updateColumnRule(descriptor);
    }

    public List<RuleDescription> getApplicableBaseColumnRules(Class<? extends DataType> dataTypeClass) {
        return this.manager.getApplicableBaseColumnRules(dataTypeClass);
    }

    public Task applyColumnRule(TabularResourceId tabularResourceId, ColumnLocalId columnId, List<RuleId> ruleIds) throws NoSuchRuleException, NoSuchTabularResourceException {
        ArrayList<Long> ruleIdsTranformed = new ArrayList<Long>(ruleIds.size());
        for (RuleId id : ruleIds) {
            ruleIdsTranformed.add(id.getValue());
        }
        TaskInfo taskInfo = this.manager.applyColumnRule(Long.valueOf(tabularResourceId.getValue()), columnId.getValue(), ruleIdsTranformed);
        return TaskFactory.getFactory().createTask(taskInfo);
    }

    public void detachColumnRules(TabularResourceId tabularResourceId, ColumnLocalId columnId, List<RuleId> ruleIds) throws NoSuchTabularResourceException {
        ArrayList<Long> ruleIdsTranformed = new ArrayList<Long>(ruleIds.size());
        for (RuleId id : ruleIds) {
            ruleIdsTranformed.add(id.getValue());
        }
        this.manager.detachColumnRules(Long.valueOf(tabularResourceId.getValue()), columnId.getValue(), ruleIdsTranformed);
    }

    public AppliedRulesResponse getAppliedRulesByTabularResourceId(TabularResourceId id) throws NoSuchTabularResourceException {
        return this.manager.getAppliedRulesByTabularResourceId(Long.valueOf(id.getValue()));
    }

    public RuleDescription share(RuleId ruleId, AuthorizationToken ... tokens) throws NoSuchRuleException, SecurityException {
        try {
            if (tokens == null || tokens.length == 0) {
                throw new RuntimeException("list of users is empty");
            }
            return (RuleDescription)this.manager.share((Object)ruleId.getValue(), tokens);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e.getMessage());
        }
    }

    public RuleDescription unshare(RuleId ruleId, AuthorizationToken ... tokens) throws NoSuchRuleException, SecurityException {
        try {
            if (tokens == null || tokens.length == 0) {
                throw new RuntimeException("list of users is empty");
            }
            return (RuleDescription)this.manager.unshare((Object)ruleId.getValue(), tokens);
        }
        catch (InternalSecurityException e) {
            throw new SecurityException(e.getMessage());
        }
    }
}

