package org.gcube.data.analysis.tabulardata.service.impl.template;

import static org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin.template;

import java.util.List;

import org.gcube.common.validator.ValidationError;
import org.gcube.common.validator.ValidatorFactory;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TemplateManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Template;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskInfo;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TemplateDescription;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTemplateException;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskFactory;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.template.TemplateId;
import org.gcube.data.analysis.tabulardata.service.template.TemplateInterface;

public class TemplateInterfaceImpl implements TemplateInterface{

	private static TemplateManagerProxy templateManager = template().build();

	public TemplateDescription getTemplate(TemplateId id) throws NoSuchTemplateException {
		try{
			return templateManager.getTemplate(id.getValue());
		}catch (org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTemplateException e) {
			throw new NoSuchTemplateException(id);
		}
	}

	public List<TemplateDescription> getTemplates() {
		return templateManager.getTemplates();
	}

	public TemplateId saveTemplate(String name, String description,
			String agency, Template template) {
		List<ValidationError> errors = ValidatorFactory.validator().validate(template);
		if (errors.size()>0) throw new RuntimeException("template not valid "+errors);
		long id = templateManager.saveTemplate(name, description, agency, template);
		return new TemplateId(id);
	}

	public Task applyTemplate(TemplateId templateId,
			TabularResourceId tabularResourceId)
					throws NoSuchTabularResourceException, NoSuchTemplateException {
		try {
			TaskInfo taskInfo = templateManager.apply(templateId.getValue(), tabularResourceId.getValue());
			return TaskFactory.getFactory().createTask(taskInfo);
		} catch (org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException e) {
			throw new NoSuchTabularResourceException(tabularResourceId);
		}catch (org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTemplateException e) {
			throw new NoSuchTemplateException(templateId);
		}
	}

}
