package org.gcube.data.analysis.tabulardata.service.impl.tabular;

import org.gcube.data.analysis.tabulardata.commons.webservice.types.HistoryData;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.operation.JobClassifier;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStep;

public class HistoryStepImpl implements HistoryStep {

	private HistoryData historyData;
	
	protected HistoryStepImpl(HistoryData historyData){
		this.historyData = historyData;
	}
	
	public OperationExecution getOperationInvocation() {
		return historyData.getInvocation();
	}

	public TableId getResultTable() {
		return historyData.getResultTableId();
	}

	public JobClassifier getOperationClassifier() {
		return JobClassifier.PROCESSING;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "HistoryStepImpl [historyData=" + historyData + "]";
	}
	
	
}
