package org.gcube.data.analysis.tabulardata.service.impl.operation.tasks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskInfo;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskInfo.TaskType;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStep;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.WorkerResult;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.WorkerStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.service.operation.Job;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskId;
import org.gcube.data.analysis.tabulardata.service.operation.TaskResult;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;

public class TaskObject implements Task, TaskObserver, Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	//private static Logger logger = LoggerFactory.getLogger(TaskObject.class);
	private TaskId taskId;
	private TaskUpdater updater;
	private TaskInfo taskInfo;
	private List<Job> jobs = null;
	
	protected TaskObject(TaskInfo taskInfo){
		super();
		this.taskInfo = taskInfo;
		this.taskId = new TaskId(taskInfo.getIdentifier());
	}
	
	
	/**
	 * @return the taskId
	 */
	public TaskId getTaskId() {
		return taskId;
	}

	
	private int getStartedSubTasks(){
		int started = 0;
		for (Job job: this.getTaskJobs())
			if (job.getStatus()!=WorkerStatus.PENDING)
				started++;
		return started;
	}

	public float getProgress() {
		checkUpdate();
		int startedSubTask = getStartedSubTasks();
		if (startedSubTask==0) return 0;
		else if (taskInfo.getTaskSteps().size()==1) return taskInfo.getTaskSteps().get(0).getProgress();
		else return taskInfo.getTaskSteps().size()/startedSubTask;
	}
	

	
	public TaskId getId() {
		return getTaskId();
	}

	

	public Date getStartTime() {
		checkUpdate();
		return taskInfo.getStartTime().getTime();
	}

	public Date getEndTime() {
		checkUpdate();
		return taskInfo.getEndTime().getTime();
	}


	public void abort() {
		/*try {
			taskManager.abort(this.getId().getValue());
		} catch (org.gcube.data.td.commons.webservice.exception.NoSuchTaskException e) {
			throw new RuntimeException(e);
		}*/
	}


	public void notify(TaskInfo task) {
		this.taskInfo = task;
		List<Job> tempJobs= new ArrayList<Job>();
		for (TaskStep step: taskInfo.getTaskSteps())
			tempJobs.add(new JobImpl(step));
		this.jobs = tempJobs;
		
		if(this.getStatus() != TaskStatus.IN_PROGRESS &&  this.getStatus() != TaskStatus.INITIALIZING && this.getStatus() != TaskStatus.VALIDATING_RULES && updater!=null)
			this.updater.unregisterObserver(this.getObserverIdentifier());
	}

	public String getObserverIdentifier() {
		return this.getId().getValue();
	}

	public TaskStatus getStatus() {
		checkUpdate();
		return taskInfo.getStatus();
	}

	public OperationExecution getInvocation() {
		//TODO: change it
		return null;
	}

	public TaskResult getResult() {
		checkUpdate();
		return new TaskResult() {
			
			public Table getPrimaryTable() {
				if (taskInfo.getResult()!=null)
					return taskInfo.getResult().getResultTable();
				else return null;
			}
			
			public List<TabularResource> getCollateralTabularResources() {
				return new ArrayList<TabularResource>();
			}
		};
	}

	public List<Job> getTaskJobs() {
		if (checkUpdate() || jobs==null){
			List<Job> tempJobs= new ArrayList<Job>();
			for (TaskStep step: taskInfo.getTaskSteps())
				tempJobs.add(new JobImpl(step));
			
			this.jobs = tempJobs;
		}
		return jobs;
	}

	
	
	
	/* (non-Javadoc)
	 * @see org.gcube.data.analysis.tabulardata.service.operation.Task#getSubmitter()
	 */
	public String getSubmitter() {
		return taskInfo.getSubmitter();
	}

	public TaskType getTaskType() {
		return taskInfo.getType();
	}

	public Throwable getErrorCause() {
		return taskInfo.getErrorCause();
	}

	/**
	 * @param updater the updater to set
	 */
	protected void setUpdater(TaskUpdater updater) {
		this.updater = updater;
		this.updater.registerObserver(this);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "TaskObject [taskId=" + taskId + ", jobs=" + getTaskJobs() + "]";
	}
	
	private boolean checkUpdate(){
		if (updater==null) return false;
		else
			return updater.checkUpdate();
		
	}
	
	class JobImpl implements Job {

		private TaskStep step;
				
		public JobImpl(TaskStep step) {
			super();
			this.step = step;
		}

		public float getProgress() {
			return step.getProgress();
		}

		public WorkerStatus getStatus() {
			return step.getStatus();
		}

		public OperationExecution getInvocation() {
			return step.getSourceInvocation();
		}

		public WorkerResult getResult() {
			return step.getResult();
		}

		public Throwable getErrorMessage() {
			return step.getError();
		}
		
	}

	
}
