/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl;

import java.util.List;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchOperationException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.service.impl.operation.OperationInterfaceImpl;
import org.gcube.data.analysis.tabulardata.service.impl.query.QueryInterfaceImpl;
import org.gcube.data.analysis.tabulardata.service.impl.tabular.TabularResourceImpl;
import org.gcube.data.analysis.tabulardata.service.operation.OperationInterface;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskId;
import org.gcube.data.analysis.tabulardata.service.query.QueryInterface;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceInterface;

public class TabularDataServiceImpl
implements TabularDataService {
    private QueryInterface queryInterface = new QueryInterfaceImpl();
    private TabularResourceInterface tabularResourceInterface = new TabularResourceImpl();
    private OperationInterface operationInterface = new OperationInterfaceImpl();

    public List<TabularResource> getTabularResources() {
        return this.tabularResourceInterface.getTabularResources();
    }

    public TabularResource getTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        return this.tabularResourceInterface.getTabularResource(id);
    }

    public void removeTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        this.tabularResourceInterface.removeTabularResource(id);
    }

    public TabularResource cloneTabularResource(TabularResourceId id) throws NoSuchTabularResourceException {
        return this.tabularResourceInterface.cloneTabularResource(id);
    }

    public TabularResource cloneTabularResource(TabularResourceId id, TableId lastTableId) throws NoSuchTabularResourceException, NoSuchTableException {
        return this.tabularResourceInterface.cloneTabularResource(id, lastTableId);
    }

    public Table getTable(TableId tableId) throws NoSuchTableException {
        return this.queryInterface.getTable(tableId);
    }

    public TabularResource createTabularResource() {
        return this.tabularResourceInterface.createTabularResource();
    }

    public Table getLastTable(TabularResourceId id) throws NoSuchTabularResourceException, InvalidTabularResourceException {
        return this.tabularResourceInterface.getLastTable(id);
    }

    public List<OperationDefinition> getCapabilities() {
        return this.operationInterface.getCapabilities();
    }

    public OperationDefinition getCapability(long operationId) throws NoSuchOperationException {
        return this.operationInterface.getCapability(operationId);
    }

    public Task execute(OperationExecution invocation, TabularResourceId tabularResourceId) throws NoSuchTabularResourceException, InvalidTabularResourceException, InvalidInvocationException {
        return this.operationInterface.execute(invocation, tabularResourceId);
    }

    public Table rollbackToTable(TabularResourceId tabularResourceId, TableId tableId) throws NoSuchTabularResourceException, NoSuchTableException {
        return null;
    }

    public List<Task> getTasks(TabularResourceId tabulaResourceId) throws NoSuchTabularResourceException {
        return this.operationInterface.getTasks(tabulaResourceId);
    }

    public Task getTask(TaskId taskId) throws NoSuchTaskException {
        return this.operationInterface.getTask(taskId);
    }

    public int getQueryLenght(TableId tableId, QueryFilter filter) throws NoSuchTableException {
        return this.queryInterface.getQueryLenght(tableId, filter);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter, QueryOrder order) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, order);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryFilter filter) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, filter);
    }

    public String queryAsJson(TableId tableId, QueryPage page, QueryOrder order) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page, order);
    }

    public String queryAsJson(TableId tableId, QueryPage page) throws NoSuchTableException {
        return this.queryInterface.queryAsJson(tableId, page);
    }

    public TabularResource share(TabularResourceId tabularResourceId, String ... users) throws NoSuchTabularResourceException {
        return this.tabularResourceInterface.unshare(tabularResourceId, users);
    }

    public TabularResource unshare(TabularResourceId tabularResourceId, String ... users) throws NoSuchTabularResourceException {
        return this.tabularResourceInterface.unshare(tabularResourceId, users);
    }

    public List<TabularResource> getTabularResourcesByType(String type) {
        return this.tabularResourceInterface.getTabularResourcesByType(type);
    }
}

