/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl.operation;

import java.util.List;
import org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.OperationManagerProxy;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TaskManagerProxy;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskFactory;
import org.gcube.data.analysis.tabulardata.service.operation.OperationInterface;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.td.commons.webservice.exception.NoSuchColumnException;
import org.gcube.data.td.commons.webservice.exception.NoSuchTaskException;
import org.gcube.data.td.commons.webservice.exception.OperationNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationInterfaceImpl
implements OperationInterface {
    private static OperationManagerProxy operationManager = (OperationManagerProxy)AbstractPlugin.operation().build();
    private static TaskManagerProxy taskManager = (TaskManagerProxy)AbstractPlugin.tasks().build();
    private static Logger logger = LoggerFactory.getLogger(OperationInterfaceImpl.class);

    public List<EligibleOperation> getCapabilities() {
        return operationManager.getCapabilities();
    }

    public List<EligibleOperation> getCapabilities(TabularResourceId tabularResourceId) throws NoSuchTabularResourceException, InvalidTabularResourceException {
        try {
            return operationManager.getCapabilities(tabularResourceId.getValue());
        }
        catch (org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException e) {
            logger.error("table with id {} not found", (Object)tabularResourceId, (Object)e);
            throw new NoSuchTabularResourceException(tabularResourceId);
        }
    }

    public List<EligibleOperation> getCapabilities(TabularResourceId tabularResourceId, ColumnLocalId columnId) throws NoSuchTabularResourceException, InvalidTabularResourceException, org.gcube.data.analysis.tabulardata.service.exception.NoSuchColumnException {
        try {
            return operationManager.getCapabilities(tabularResourceId.getValue(), columnId.getValue());
        }
        catch (org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException e) {
            logger.error("table with id {} not found", (Object)tabularResourceId, (Object)e);
            throw new NoSuchTabularResourceException(tabularResourceId);
        }
        catch (NoSuchColumnException e) {
            logger.error("column with id {} not found", (Object)columnId.getValue(), (Object)e);
            throw new org.gcube.data.analysis.tabulardata.service.exception.NoSuchColumnException("column with id " + columnId.getValue() + " not found");
        }
    }

    public Task execute(OperationInvocation invocation, TabularResourceId targetTabularResourceId) throws NoSuchTabularResourceException, InvalidTabularResourceException, InvalidInvocationException {
        try {
            return TaskFactory.createTask(operationManager.execute(invocation, targetTabularResourceId.getValue()), taskManager);
        }
        catch (org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException e) {
            throw new NoSuchTabularResourceException(targetTabularResourceId);
        }
        catch (org.gcube.data.td.commons.webservice.exception.InvalidInvocationException e) {
            throw new InvalidInvocationException((Throwable)e);
        }
        catch (OperationNotFoundException e) {
            throw new InvalidInvocationException((Throwable)e);
        }
    }

    public Table rollbackToTable(TabularResourceId tabularResourceId, TableId toTableId) throws NoSuchTabularResourceException, NoSuchTableException {
        return null;
    }

    public List<Task> getTasks(TabularResourceId tabularResourceId) throws NoSuchTabularResourceException {
        return null;
    }

    public Task getTask(Task.TaskId taskId, TabularResourceId tabularResourceId) throws org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException, NoSuchTabularResourceException {
        try {
            return TaskFactory.getTask(taskId.getValue(), taskManager);
        }
        catch (NoSuchTaskException e) {
            throw new org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException(tabularResourceId, taskId);
        }
    }
}

