/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl.operation.tasks;

import java.io.Serializable;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TaskManagerProxy;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskObserver;
import org.gcube.data.td.commons.webservice.types.TaskInfo;

public class TaskUpdater
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TaskManagerProxy proxy;
    private final long MILLIS_FOR_UPDATE = 5000L;
    Long timestamp;
    private TaskObserver observer;

    public TaskUpdater(TaskManagerProxy proxy) {
        this.proxy = proxy;
        this.timestamp = System.currentTimeMillis();
    }

    void registerObserver(TaskObserver observer) {
        this.observer = observer;
    }

    void checkUpdate() {
        long actualTimestamp = System.currentTimeMillis();
        System.out.println("checking updates " + (this.observer != null) + " " + (actualTimestamp - this.timestamp > 5000L));
        if (this.observer != null && actualTimestamp - this.timestamp > 5000L) {
            this.notifiesObservers(this.callUpdate());
            this.timestamp = System.currentTimeMillis();
        }
    }

    private TaskInfo callUpdate() {
        try {
            return this.proxy.get(this.observer.getObserverIdentifier());
        }
        catch (Exception e) {
            throw new RuntimeException("error updating task, not found on server");
        }
    }

    private void notifiesObservers(TaskInfo task) {
        this.observer.notify(task);
    }

    public void removeObserver(String observerIdentifier) {
        this.observer = null;
    }
}

