/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.test;

import java.util.Map;
import javax.inject.Inject;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationScope;
import org.gcube.data.analysis.tabulardata.operation.invocation.InvocationCreator;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.test.FactoryChecker;
import org.gcube.data.analysis.tabulardata.operation.test.WorkerChecker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class OperationTester<T extends WorkerFactory> {
    FactoryChecker factoryChecker;
    WorkerChecker workerChecker;
    @Inject
    private CubeManager cubeManager;

    @Before
    public void setupFactoryChecker() {
        this.factoryChecker = new FactoryChecker(this.getFactory());
    }

    protected abstract WorkerFactory getFactory();

    @BeforeClass
    public static void beforeClass() {
        ScopeProvider.instance.set("/gcube/devsec");
    }

    private OperationInvocation createOperationInvocation() {
        OperationDescriptor descriptor = this.getFactory().getOperationDescriptor();
        InvocationCreator creator = InvocationCreator.getCreator((OperationDescriptor)descriptor);
        creator.setParameters(this.getParameterInstances());
        OperationScope scope = descriptor.getScope();
        if (scope == OperationScope.TABLE || scope == OperationScope.COLUMN) {
            creator.setTargetTable(this.getTargetTableId());
        }
        if (scope == OperationScope.COLUMN) {
            creator.setTargetColumn(this.getTargetColumnId());
        }
        return creator.create();
    }

    @Test
    public final void testFactory() {
        this.factoryChecker.check();
    }

    protected abstract Map<String, Object> getParameterInstances();

    @Test
    public final void testWorker() throws InvalidInvocationException {
        OperationInvocation invocation = this.createOperationInvocation();
        this.workerChecker = new WorkerChecker(this.cubeManager, this.getFactory().createWorker(invocation));
        this.workerChecker.setCheckFallback(this.checkFallback());
        this.workerChecker.check();
    }

    protected boolean checkFallback() {
        return true;
    }

    protected abstract ColumnLocalId getTargetColumnId();

    protected abstract TableId getTargetTableId();
}

