/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical.specific;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.dsl.Comparators;
import org.gcube.data.analysis.tabulardata.expression.dsl.Logicals;
import org.gcube.data.analysis.tabulardata.expression.dsl.Types;
import org.gcube.data.analysis.tabulardata.expression.logical.And;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetViewTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.HierarchicalCodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.TimeCodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.add.AddColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.BooleanParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MultivaluedStringParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TDTypeValueParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.specific.EnhanceLatLong;
import org.gcube.data.analysis.tabulardata.statistical.specific.LatLongFeature;

@Singleton
public class EnhanceLatLonFactory
extends TableTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(10101L);
    private static final List<TableType> allTableTypes = new ArrayList<TableType>();
    private static final List<ColumnType> numericTypes = new ArrayList<ColumnType>();
    private static final List<DataType> numericDataTypes = new ArrayList<DataType>();
    private static final List<String> features = new ArrayList<String>();
    public static final TargetColumnParameter LATITUDE_COLUMN_PARAM;
    public static final TargetColumnParameter LONGITUTE_COLUMN_PARAM;
    public static final TargetColumnParameter QUADRANT_COLUMN_PARAMETER;
    public static final TDTypeValueParameter RESOLUTION_PARAM;
    public static final MultivaluedStringParameter TO_ADD_FEATURE_PARAM;
    public static final BooleanParameter DELETE_GENERATED;
    public static final BooleanParameter DELETE_REMOTE;
    private static List<Parameter> params;
    private CubeManager cm;
    private StatisticalOperationFactory statFactory;
    private AddColumnFactory addColFactory;
    private ValidateDataWithExpressionFactory validationFactory;

    @Inject
    public EnhanceLatLonFactory(CubeManager cm, StatisticalOperationFactory statFactory, AddColumnFactory addColFactory, ValidateDataWithExpressionFactory validationFactory) {
        this.cm = cm;
        this.statFactory = statFactory;
        this.addColFactory = addColFactory;
        this.validationFactory = validationFactory;
    }

    public DataWorker createWorker(OperationInvocation arg0) throws InvalidInvocationException {
        this.performBaseChecks(arg0, this.cm);
        this.performSpecificChecks(arg0);
        this.checkEnvironment(arg0);
        return new EnhanceLatLong(arg0, this.statFactory, this.addColFactory, this.cm);
    }

    private void checkEnvironment(OperationInvocation invocation) throws InvalidInvocationException {
        String toUseAlgorithm = null;
        LatLongFeature feature = LatLongFeature.valueOf((String)OperationHelper.getParameter((LeafParameter)TO_ADD_FEATURE_PARAM, (OperationInvocation)invocation));
        switch (feature) {
            case CSQUARECODE: {
                toUseAlgorithm = "org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.CSQUARE_COLUMN_CREATOR";
                break;
            }
            case OCEANAREA: {
                toUseAlgorithm = invocation.getParameterInstances().containsKey(QUADRANT_COLUMN_PARAMETER.getIdentifier()) ? "org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.FAO_OCEAN_AREA_COLUMN_CREATOR_FROM_QUADRANT" : "org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.FAO_OCEAN_AREA_COLUMN_CREATOR";
            }
        }
    }

    private void performSpecificChecks(OperationInvocation invocation) throws InvalidInvocationException {
        TableId tableId = invocation.getTargetTableId();
        if (!((ColumnReference)OperationHelper.getParameter((LeafParameter)LATITUDE_COLUMN_PARAM, (OperationInvocation)invocation)).getTableId().equals((Object)tableId)) {
            throw new InvalidInvocationException(invocation, "Latitude column not present in this table, tableID is : " + ((ColumnReference)OperationHelper.getParameter((LeafParameter)LATITUDE_COLUMN_PARAM, (OperationInvocation)invocation)).getTableId());
        }
        if (!((ColumnReference)OperationHelper.getParameter((LeafParameter)LONGITUTE_COLUMN_PARAM, (OperationInvocation)invocation)).getTableId().equals((Object)tableId)) {
            throw new InvalidInvocationException(invocation, "Longitude column not present in this table, tableID is : " + ((ColumnReference)OperationHelper.getParameter((LeafParameter)LONGITUTE_COLUMN_PARAM, (OperationInvocation)invocation)).getTableId());
        }
        try {
            if (!((ColumnReference)OperationHelper.getParameter((LeafParameter)QUADRANT_COLUMN_PARAMETER, (OperationInvocation)invocation)).getTableId().equals((Object)tableId)) {
                throw new InvalidInvocationException(invocation, "Quadrant column not present in this table, tableID is : " + ((ColumnReference)OperationHelper.getParameter((LeafParameter)QUADRANT_COLUMN_PARAMETER, (OperationInvocation)invocation)).getTableId());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected String getOperationDescription() {
        return "Adds a geospatial feature based on latitude and longitude columns, relying on Statistical Manager's facilities.";
    }

    protected String getOperationName() {
        return "EnhanceLatLong";
    }

    protected List<Parameter> getParameters() {
        return params;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public Map<String, WorkerFactory<ValidationWorker>> getPreconditionValidationMap() {
        return Collections.singletonMap("expression", this.validationFactory);
    }

    public Map<String, Object> getParametersForPrecondion(String identifier, TableId table, ColumnLocalId columnId, Map<String, Object> sourceParameterInstance) {
        switch (identifier) {
            case "expression": {
                return this.createExpressionParameters(sourceParameterInstance);
            }
        }
        return sourceParameterInstance;
    }

    private Map<String, Object> createExpressionParameters(Map<String, Object> sourceParameterInstance) {
        ColumnReference latitude = (ColumnReference)OperationHelper.getParameter((LeafParameter)LATITUDE_COLUMN_PARAM, sourceParameterInstance);
        ColumnReference longitude = (ColumnReference)OperationHelper.getParameter((LeafParameter)LONGITUTE_COLUMN_PARAM, sourceParameterInstance);
        ColumnReference quadrant = null;
        LatLongFeature feature = LatLongFeature.valueOf((String)OperationHelper.getParameter((LeafParameter)TO_ADD_FEATURE_PARAM, sourceParameterInstance));
        try {
            quadrant = (ColumnReference)OperationHelper.getParameter((LeafParameter)QUADRANT_COLUMN_PARAMETER, sourceParameterInstance);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String description = null;
        And expression = null;
        HashMap<String, Object> validationParameters = new HashMap<String, Object>();
        validationParameters.put(ValidateDataWithExpressionFactory.VALIDATION_TITLE_PARAMETER.getIdentifier(), "Coordinates validation");
        if (feature == LatLongFeature.OCEANAREA && quadrant != null) {
            description = String.format("Longitude value must be between [-180, 180], Latitude value must be between [-90, 90] and Quadrant value must be between [1,4] ", new Object[0]);
            expression = Logicals.and((Expression[])new Expression[]{Comparators.lessEq((Expression)longitude, (Expression)Types.numeric((double)180.0)), Comparators.greaterEq((Expression)longitude, (Expression)Types.numeric((double)0.0)), Comparators.lessEq((Expression)latitude, (Expression)Types.numeric((double)90.0)), Comparators.greaterEq((Expression)latitude, (Expression)Types.numeric((double)0.0)), Comparators.lessEq((Expression)quadrant, (Expression)Types.numeric((double)4.0)), Comparators.greaterEq((Expression)quadrant, (Expression)Types.numeric((double)1.0))});
        } else {
            description = String.format("Longitude value must be between [-180, 180], Latitude value must be between [-90, 90]", new Object[0]);
            expression = Logicals.and((Expression[])new Expression[]{Comparators.lessEq((Expression)longitude, (Expression)Types.numeric((double)180.0)), Comparators.greaterEq((Expression)longitude, (Expression)Types.numeric((double)-180.0)), Comparators.lessEq((Expression)latitude, (Expression)Types.numeric((double)90.0)), Comparators.greaterEq((Expression)latitude, (Expression)Types.numeric((double)-90.0))});
        }
        validationParameters.put(ValidateDataWithExpressionFactory.DESCRIPTION_PARAMETER.getIdentifier(), description);
        validationParameters.put(ValidateDataWithExpressionFactory.EXPRESSION_PARAMETER.getIdentifier(), expression);
        validationParameters.put(ValidateDataWithExpressionFactory.VALIDATION_CODE_PARAMETER.getIdentifier(), "302");
        return validationParameters;
    }

    static {
        allTableTypes.add((TableType)new CodelistTableType());
        allTableTypes.add((TableType)new DatasetTableType());
        allTableTypes.add((TableType)new DatasetViewTableType());
        allTableTypes.add((TableType)new GenericTableType());
        allTableTypes.add((TableType)new HierarchicalCodelistTableType());
        allTableTypes.add((TableType)new TimeCodelistTableType());
        numericTypes.add((ColumnType)new AttributeColumnType());
        numericTypes.add((ColumnType)new MeasureColumnType());
        numericTypes.add((ColumnType)new AnnotationColumnType());
        numericDataTypes.add((DataType)new IntegerType());
        numericDataTypes.add((DataType)new NumericType());
        for (LatLongFeature feat : LatLongFeature.values()) {
            features.add(feat.name());
        }
        LATITUDE_COLUMN_PARAM = new TargetColumnParameter("latitude", "Latitude Column", "The column containing latitude information", Cardinality.ONE, allTableTypes, numericTypes, numericDataTypes);
        LONGITUTE_COLUMN_PARAM = new TargetColumnParameter("longitude", "Longitude Column", "The column containing longitude information", Cardinality.ONE, allTableTypes, numericTypes, numericDataTypes);
        QUADRANT_COLUMN_PARAMETER = new TargetColumnParameter("quadrant", "Quadrant Column", "The column containing quadrant information", Cardinality.OPTIONAL, allTableTypes, numericTypes, Collections.singletonList(new IntegerType()));
        RESOLUTION_PARAM = new TDTypeValueParameter("resolution", "CSquare Code Resolution", "Resolution of the resulting csquarecodes", Cardinality.OPTIONAL, Collections.singletonList(new NumericType()));
        TO_ADD_FEATURE_PARAM = new MultivaluedStringParameter("feature", "To Add Feature", "Feature to be added to the table", Cardinality.ONE, features);
        DELETE_GENERATED = StatisticalOperationFactory.CLEAR_DATASPACE;
        DELETE_REMOTE = StatisticalOperationFactory.REMOVE_EXPORTED;
        params = Arrays.asList(LATITUDE_COLUMN_PARAM, LONGITUTE_COLUMN_PARAM, QUADRANT_COLUMN_PARAMETER, RESOLUTION_PARAM, TO_ADD_FEATURE_PARAM, DELETE_GENERATED, DELETE_REMOTE);
    }
}

