/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ImportWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.importer.csv.CSVImportFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.BooleanParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.SimpleStringParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.statistical.Common;
import org.gcube.data.analysis.tabulardata.statistical.ImportFromStatisticalOperation;

@Singleton
public class ImportFromStatisticalOperationFactory
extends ImportWorkerFactory {
    private static OperationId OPERATION_ID = new OperationId(10003L);
    private static List<Parameter> parameters = new ArrayList<Parameter>();
    public static final SimpleStringParameter RESOURCE_ID = new SimpleStringParameter("resourceId", "Resource id", "The table id inside the dataspace", Cardinality.ONE);
    public static final SimpleStringParameter RESOURCE_NAME = new SimpleStringParameter("resourceName", "Resource Name", "The label to be given to the table", Cardinality.OPTIONAL);
    public static final BooleanParameter DELETE_REMOTE_RESOURCE = new BooleanParameter("delete_remote", "Delete remote", "True to delete remote resource after importing", Cardinality.OPTIONAL);
    private CubeManager cubeManager;
    private CSVImportFactory csvImportFactory;

    static {
        parameters.add((Parameter)RESOURCE_ID);
        parameters.add((Parameter)RESOURCE_NAME);
        parameters.add((Parameter)DELETE_REMOTE_RESOURCE);
    }

    @Inject
    public ImportFromStatisticalOperationFactory(CubeManager cubeManager, CSVImportFactory csvImportFactory) {
        this.cubeManager = cubeManager;
        this.csvImportFactory = csvImportFactory;
    }

    public DataWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        SClient dmClient = null;
        try {
            dmClient = Common.getDMClient();
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, "Statistical Service not available, please contact your VRE Manager", e);
        }
        IClient client = new StorageClient("StatisticalOperations", "StatisticalOperations", "service", AccessType.SHARED).getClient();
        return new ImportFromStatisticalOperation(this.cubeManager, invocation, dmClient, this.csvImportFactory, client);
    }

    protected String getOperationName() {
        return "Import from Statistical";
    }

    protected String getOperationDescription() {
        return "Import the selected resource as CSV generic table.";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }
}

