/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import net.sf.csv4j.ParseException;
import net.sf.csv4j.ProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReservedWordsDictionary {
    private static Logger logger = LoggerFactory.getLogger(ReservedWordsDictionary.class);
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static ReservedWordsDictionary singleton;
    private static final long dictionaryTTL = 300000L;
    private static long lastAccessedTime;
    private static Semaphore sem;
    private HashSet<String> reservedKeywords = new HashSet();

    static {
        scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    sem.acquire();
                    if (System.currentTimeMillis() - lastAccessedTime > 300000L) {
                        singleton = null;
                    }
                    sem.release();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, 5L, 5L, TimeUnit.MINUTES);
        lastAccessedTime = 0L;
        sem = new Semaphore(0, true);
    }

    public static synchronized ReservedWordsDictionary getDictionary() throws ParseException, IOException, ProcessingException {
        lastAccessedTime = System.currentTimeMillis();
        if (singleton == null) {
            singleton = new ReservedWordsDictionary();
            sem.release();
        }
        return singleton;
    }

    private ReservedWordsDictionary() throws ParseException, IOException, ProcessingException {
        logger.debug("Initializing dicionary");
        CSVReaderProcessor processor = new CSVReaderProcessor();
        processor.setDelimiter(',');
        processor.setHasHeader(false);
        InputStreamReader reader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("reservedWords.csv"), Charset.defaultCharset());
        processor.processStream((Reader)reader, new CSVLineProcessor(){

            public void processHeaderLine(int arg0, List<String> arg1) {
            }

            public void processDataLine(int arg0, List<String> arg1) {
                if (arg1.get(1).equals("reserved")) {
                    ReservedWordsDictionary.this.reservedKeywords.add(arg1.get(0));
                }
            }

            public boolean continueProcessing() {
                return true;
            }
        });
        logger.debug("Found " + this.reservedKeywords.size());
    }

    public boolean isReservedKeyWord(String str) {
        return this.reservedKeywords.contains(str.toUpperCase());
    }
}

