/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.csv4j.ParseException;
import net.sf.csv4j.ProcessingException;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GcubeServiceReferenceMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.export.csv.exporter.CSVExportFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.data.analysis.tabulardata.statistical.Common;
import org.gcube.data.analysis.tabulardata.statistical.ExportToStatisticalOperationFactory;

public class ExportToStatisticalOperation
extends ResourceCreatorWorker {
    private CSVExportFactory csvExportFactory;
    private CubeManager cubeManager;
    private Table targetTable;
    private Set<String> toEscapeFieldNames = new HashSet<String>();
    private ResourcesResult exportedTable;

    public ExportToStatisticalOperation(OperationInvocation sourceInvocation, CSVExportFactory csvExportFactory, CubeManager cubeManager) {
        super(sourceInvocation);
        this.csvExportFactory = csvExportFactory;
        this.cubeManager = cubeManager;
    }

    public ResourcesResult execute() throws WorkerException, OperationAbortedException {
        try {
            this.loadParameters();
            this.updateProgress(0.1f, "Creating csv");
            this.exportCSV();
            this.updateProgress(0.9f, "Finalizing");
            TableMetaCreator tmc = this.cubeManager.modifyTableMeta(this.getSourceInvocation().getTargetTableId());
            tmc.setTableMetadata(new TableMetadata[]{new GcubeServiceReferenceMetadata("WPS", "DataMiner", new Date(), ((ResourceDescriptorResult)this.exportedTable.getResources().iterator().next()).getResource().getStringValue())});
            tmc.create();
            return this.exportedTable;
        }
        catch (WorkerException e) {
            throw e;
        }
        catch (OperationAbortedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkerException("Unexpected internal error. Please contact support", (Throwable)e);
        }
    }

    private void loadParameters() {
        Map params = this.getSourceInvocation().getParameterInstances();
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        if (params.containsKey(ExportToStatisticalOperationFactory.toEscapeFieldNamesParam.getIdentifier())) {
            Object paramValue = OperationHelper.getParameter((LeafParameter)ExportToStatisticalOperationFactory.toEscapeFieldNamesParam, (OperationInvocation)this.getSourceInvocation());
            if (paramValue instanceof Iterable) {
                for (String s : (Iterable)paramValue) {
                    this.toEscapeFieldNames.add(s);
                }
            } else {
                this.toEscapeFieldNames.add((String)paramValue);
            }
        }
    }

    private void exportCSV() throws WorkerException, OperationAbortedException, ParseException, IOException, ProcessingException {
        boolean changedMeta;
        TableMetaCreator tmc;
        HashMap<ColumnLocalId, String> toRestoreLabels;
        block8: {
            HashMap<String, Object> exportParams = new HashMap<String, Object>();
            ArrayList<String> columns = new ArrayList<String>();
            toRestoreLabels = new HashMap<ColumnLocalId, String>();
            if (this.targetTable.contains(DatasetViewTableMetadata.class)) {
                DatasetViewTableMetadata dsMeta = (DatasetViewTableMetadata)this.targetTable.getMetadata(DatasetViewTableMetadata.class);
                this.targetTable = this.cubeManager.getTable(dsMeta.getTargetDatasetViewTableId());
            }
            tmc = this.cubeManager.modifyTableMeta(this.targetTable.getId());
            Map<ColumnLocalId, String> curatedLabels = Common.curateLabels(this.targetTable, this.toEscapeFieldNames.toArray(new String[this.toEscapeFieldNames.size()]));
            changedMeta = false;
            for (Map.Entry<ColumnLocalId, String> entry : curatedLabels.entrySet()) {
                columns.add(entry.getKey().getValue());
                String originalLabel = OperationHelper.retrieveColumnLabel((Column)this.targetTable.getColumnById(entry.getKey()));
                if (originalLabel.equals(entry.getValue())) continue;
                toRestoreLabels.put(entry.getKey(), originalLabel);
                tmc.setColumnMetadata(entry.getKey(), new ColumnMetadata[]{new NamesMetadata(Collections.singletonList(new ImmutableLocalizedText(entry.getValue())))});
                changedMeta = true;
            }
            if (changedMeta) {
                tmc.create();
            }
            exportParams.put("columns", columns);
            exportParams.put("encoding", Charset.defaultCharset().toString());
            exportParams.put("separator", ",");
            exportParams.put("useView", new Boolean(false));
            WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.csvExportFactory);
            try {
                WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, exportParams);
                if (status.equals((Object)WorkerStatus.SUCCEDED)) {
                    this.exportedTable = (ResourcesResult)wrapper.getResult();
                    break block8;
                }
                throw new WorkerException("Failed export to CSV, worker status was " + status);
            }
            catch (InvalidInvocationException e) {
                throw new WorkerException("Unable to export table as CSV", (Throwable)e);
            }
        }
        if (changedMeta) {
            for (Map.Entry entry : toRestoreLabels.entrySet()) {
                tmc.setColumnMetadata((ColumnLocalId)entry.getKey(), new ColumnMetadata[]{new NamesMetadata(Collections.singletonList(new ImmutableLocalizedText((String)entry.getValue())))});
            }
            tmc.create();
        }
    }
}

