/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.OperationType;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableResourceCreatorWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.BooleanParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MapParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.data.analysis.tabulardata.statistical.Common;
import org.gcube.data.analysis.tabulardata.statistical.ExportToStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.ImportFromStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperation;

@Singleton
public class StatisticalOperationFactory
extends TableResourceCreatorWorkerFactory {
    private static OperationId OPERATION_ID = new OperationId(10001L);
    public static MapParameter SM_ENTRIES = new MapParameter("operator", "Operator Holder", "This map is expected to contain only one Operator object under key operator", Cardinality.ONE, String.class, Operator.class, Collections.singletonList("operator"));
    public static BooleanParameter CLEAR_DATASPACE = new BooleanParameter("clear", "Clear Dataspace", "Remove all generated resources from dataspace", Cardinality.OPTIONAL);
    public static BooleanParameter REMOVE_EXPORTED = new BooleanParameter("remove", "Remove Exported", "Remove table from dataspace", Cardinality.OPTIONAL);
    private static List<Parameter> parameters = new ArrayList<Parameter>();
    private ExportToStatisticalOperationFactory exportFactory;
    private ImportFromStatisticalOperationFactory importFactory;
    private CubeManager cubeManager;

    static {
        parameters.add((Parameter)SM_ENTRIES);
        parameters.add((Parameter)CLEAR_DATASPACE);
        parameters.add((Parameter)REMOVE_EXPORTED);
        parameters.add((Parameter)ExportToStatisticalOperationFactory.toEscapeFieldNamesParam);
    }

    @Inject
    public StatisticalOperationFactory(ExportToStatisticalOperationFactory exportFactory, ImportFromStatisticalOperationFactory importFactory, CubeManager cubeManager) {
        this.exportFactory = exportFactory;
        this.importFactory = importFactory;
        this.cubeManager = cubeManager;
    }

    public ResourceCreatorWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        SClient dmClient = null;
        try {
            dmClient = Common.getDMClient();
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, "Statistical Service not available, please contact your VRE Manager", e);
        }
        StatisticalOperationFactory.checkSMParameters(dmClient, invocation);
        Home home = null;
        try {
            home = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome();
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, "Unable to contact user's home library", e);
        }
        return new StatisticalOperation(invocation, dmClient, this.exportFactory, this.importFactory, home, this.cubeManager);
    }

    private static void checkSMParameters(SClient dmClient, OperationInvocation invocation) throws InvalidInvocationException {
        try {
            Operator operator = Common.getOperator(invocation);
            dmClient.getOperatorById(operator.getId());
            HashSet<String> passedParametersName = new HashSet<String>();
            for (org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter param : operator.getOperatorParameters()) {
                passedParametersName.add(param.getName());
            }
            for (org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter param : dmClient.getInputParameters(operator)) {
                if (passedParametersName.contains(param.getName())) continue;
                throw new InvalidInvocationException(invocation, "Expected parameter " + param.getName() + " not specified in operator.");
            }
        }
        catch (InvalidInvocationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, "Unable to check parameters for selected algorithm : " + e.getMessage());
        }
    }

    protected String getOperationName() {
        return "Statistical Operation";
    }

    protected String getOperationDescription() {
        return "Execute a Statistical Manager experiment against the selected target table";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        String algorithmId = Common.getOperator(invocation).getName();
        return String.format("Execute %s Algorithm", algorithmId);
    }

    protected OperationType getOperationType() {
        return OperationType.RESOURCECREATOR;
    }
}

