/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.sf.csv4j.ParseException;
import net.sf.csv4j.ProcessingException;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.data.analysis.dataminermanagercl.server.DataMinerService;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.FileResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.ImageResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.MapResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.ObjectResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.Resource;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.resources.InternalURI;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.resources.TableResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.export.Utils;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableTableResource;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableURIResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.statistical.ImportFromStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.ReservedWordsDictionary;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperationFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Common {
    private static final Logger log = LoggerFactory.getLogger(Common.class);

    public static boolean isValidColumnName(Column col) throws ParseException, IOException, ProcessingException {
        String currentLabel = OperationHelper.retrieveColumnLabel((Column)col);
        return Common.isValidString(currentLabel);
    }

    public static boolean isValidString(String str) throws ParseException, IOException, ProcessingException {
        return str.matches("^[a-z_][a-z_0-9]*") && !ReservedWordsDictionary.getDictionary().isReservedKeyWord(str);
    }

    public static String fixColumnName(String columnName) throws ParseException, IOException, ProcessingException {
        String toReturn = columnName.replaceAll("\\W", "_").toLowerCase();
        if (Common.isValidString(toReturn)) {
            return toReturn;
        }
        return "_" + toReturn;
    }

    public static String fixColumnName(String columnName, String ... additionalReservedWords) throws ParseException, IOException, ProcessingException {
        String toCheck = Common.fixColumnName(columnName);
        String[] stringArray = additionalReservedWords;
        int n = additionalReservedWords.length;
        int n2 = 0;
        while (n2 < n) {
            String additional = stringArray[n2];
            if (toCheck.equalsIgnoreCase(additional)) {
                toCheck = "_" + toCheck;
            }
            ++n2;
        }
        return toCheck;
    }

    public static String fixColumnName(Column col, String ... additionalReservedWords) throws ParseException, IOException, ProcessingException {
        return Common.fixColumnName(OperationHelper.retrieveColumnLabel((Column)col), additionalReservedWords);
    }

    public static Map<ColumnLocalId, String> curateLabels(Table table, String ... additionalReservedWords) throws ParseException, IOException, ProcessingException {
        HashMap<ColumnLocalId, String> toReturn = new HashMap<ColumnLocalId, String>();
        HashMap<String, Integer> clashCounter = new HashMap<String, Integer>();
        for (Column col : table.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
            String originalLabel = OperationHelper.retrieveColumnLabel((Column)col);
            String fixed = Common.fixColumnName(originalLabel, additionalReservedWords);
            if (clashCounter.containsKey(fixed)) {
                clashCounter.put(fixed, (Integer)clashCounter.get(fixed) + 1);
                fixed = String.valueOf(fixed) + "_" + clashCounter.get(fixed);
            } else {
                clashCounter.put(fixed, 1);
            }
            toReturn.put(col.getLocalId(), fixed);
        }
        return toReturn;
    }

    public static SClient getDMClient() throws Exception {
        return new DataMinerService().getClient();
    }

    public static Operator getOperator(OperationInvocation invocation) {
        Map param = (Map)OperationHelper.getParameter((LeafParameter)StatisticalOperationFactory.SM_ENTRIES, (OperationInvocation)invocation);
        return (Operator)param.get("operator");
    }

    public static URL getURLFromStorageId(String id) throws MalformedURLException, RemoteBackendException {
        return new URL(Utils.getStorageClient().getHttpUrl().RFile(id));
    }

    public static Home getHL() throws InternalErrorException, HomeNotFoundException, UserNotFoundException {
        return HomeLibrary.getHomeManagerFactory().getHomeManager().getHome();
    }

    public static void handleSMResource(Resource toHandle, List<ResourceDescriptorResult> results, Map<String, String> toSerializeValues, WorkerWrapper<DataWorker, WorkerResult> wrapper, boolean clearDataSpace, Home home) throws WorkerException {
        try {
            log.debug("Handling resource {} : {} [{}]", new Object[]{toHandle.getName(), toHandle.getResourceId(), toHandle.getResourceType()});
            switch (toHandle.getResourceType()) {
                case TABULAR: {
                    Table table = Common.importFromTableSpace(toHandle.getResourceId(), toHandle.getName(), wrapper, clearDataSpace);
                    results.add((ResourceDescriptorResult)new ImmutableTableResource(new TableResource(table.getId()), OperationHelper.retrieveTableLabel((Table)table), "Imported from SM", ResourceType.GENERIC_TABLE));
                    break;
                }
                case MAP: {
                    MapResource resource = (MapResource)toHandle;
                    for (Map.Entry entry : resource.getMap().entrySet()) {
                        Resource res = (Resource)entry.getValue();
                        Common.handleSMResource(res, results, toSerializeValues, wrapper, clearDataSpace, home);
                    }
                    break;
                }
                case OBJECT: {
                    ObjectResource objRes = (ObjectResource)toHandle;
                    toSerializeValues.put(String.format("%s [%s]", objRes.getDescription(), objRes.getName()), objRes.getResourceId());
                    break;
                }
                case FILE: {
                    FileResource smFile = (FileResource)toHandle;
                    if (smFile.getMimeType().equals("text/csv")) {
                        log.debug("Resource {}:ID {} is csv. Importing as table.", (Object)smFile.getName(), (Object)smFile.getResourceId());
                        Table table = Common.importFromTableSpace(smFile.getUrl(), smFile.getName(), wrapper, clearDataSpace);
                        results.add((ResourceDescriptorResult)new ImmutableTableResource(new TableResource(table.getId()), OperationHelper.retrieveTableLabel((Table)table), "Imported from SM", ResourceType.GENERIC_TABLE));
                        break;
                    }
                    log.debug("Resource {}:ID {} is mimetype {} . Importing as FILE .", new Object[]{smFile.getName(), smFile.getResourceId(), smFile.getMimeType()});
                    results.add((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(smFile.getUrl()), smFile.getMimeType()), smFile.getName(), smFile.getDescription(), ResourceType.GENERIC_FILE));
                    break;
                }
                case IMAGE: {
                    ImageResource imgRes = (ImageResource)toHandle;
                    results.add((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(imgRes.getLink()), imgRes.getMimeType()), imgRes.getName(), imgRes.getDescription(), ResourceType.CHART));
                }
            }
        }
        catch (Exception e) {
            log.warn("Unable to get resource " + toHandle, (Throwable)e);
        }
    }

    private static Table importFromTableSpace(String resourceID, String tableName, WorkerWrapper<DataWorker, WorkerResult> wrapper, boolean clearDataSpace) throws WorkerException, OperationAbortedException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(ImportFromStatisticalOperationFactory.RESOURCE_ID.getIdentifier(), resourceID);
            params.put(ImportFromStatisticalOperationFactory.RESOURCE_NAME.getIdentifier(), tableName);
            params.put(ImportFromStatisticalOperationFactory.DELETE_REMOTE_RESOURCE.getIdentifier(), clearDataSpace);
            WorkerStatus status = wrapper.execute(null, null, params);
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Failed export to dataspace");
            }
            return ((WorkerResult)wrapper.getResult()).getResultTable();
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to import table from dataspace.", (Throwable)e);
        }
    }

    private static List<ResourceDescriptorResult> getFilesUrlFromFolderUrl(String url, Home home) throws WorkerException {
        try {
            ArrayList<ResourceDescriptorResult> toReturn = new ArrayList<ResourceDescriptorResult>();
            String callerScope = ScopeProvider.instance.get();
            ScopeBean scope = new ScopeBean(callerScope);
            while (!scope.is(ScopeBean.Type.INFRASTRUCTURE)) {
                scope = scope.enclosingScope();
            }
            ScopeProvider.instance.set(scope.toString());
            String HLServiceName = null;
            String HLPackage = "org.gcube.portlets.user";
            String HLResourceName = "HomeLibraryRepository";
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Category/text() eq 'Database' and $resource/Profile/Name eq '" + HLResourceName + "' ");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            for (ServiceEndpoint.AccessPoint ap : ((ServiceEndpoint)client.submit((Query)query).get(0)).profile().accessPoints()) {
                if (!ap.name().equals("ServiceName")) continue;
                HLServiceName = ap.address();
                break;
            }
            IClient storage = Utils.getStorageClient();
            Workspace ws = home.getWorkspace();
            WorkspaceItem folderItem = ws.getItemByPath(url);
            WorkspaceFolder folder = (WorkspaceFolder)folderItem;
            List childrenList = folder.getChildren();
            for (WorkspaceItem item : childrenList) {
                ExternalImage file = (ExternalImage)item;
                String name = item.getName();
                String mimeType = file.getMimeType();
                if (mimeType.equalsIgnoreCase("png")) {
                    mimeType = "image/png";
                }
                MyFile storageFile = storage.getMetaFile().RFile(file.getRemotePath());
                toReturn.add((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(storageFile.getId()), mimeType), name, item.getDescription(), ResourceType.GENERIC_FILE));
            }
            ScopeProvider.instance.set(callerScope);
            return toReturn;
        }
        catch (Exception e) {
            throw new WorkerException("Unable to retrieve results from workspace ", (Throwable)e);
        }
    }

    private static InputStream getStorageClientInputStream(String url) throws Exception {
        return new URL(url).openConnection().getInputStream();
    }

    private static MyFile getStorageFileDescriptor(String resourceUrl) throws RemoteBackendException, Exception {
        try {
            return Utils.getStorageClient().getMetaFile().RFile(resourceUrl);
        }
        catch (Exception e) {
            log.debug("Not a valid file id " + resourceUrl + ", copying by stream");
            IClient client = Utils.getStorageClient();
            String id = client.put(true).LFile(Common.getStorageClientInputStream(resourceUrl)).RFile(UUID.randomUUID().toString());
            log.debug("Copied to new id : " + id);
            return Utils.getStorageClient().getMetaFile().RFile(id);
        }
    }
}

