/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.sf.csv4j.ParseException;
import net.sf.csv4j.ProcessingException;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDSL;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMTypeParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMFile;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMObject;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMResource;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMTable;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.resources.InternalURI;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.resources.TableResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.export.Utils;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableTableResource;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableURIResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.statistical.ImportFromStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.ReservedWordsDictionary;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Common {
    private static Logger logger = LoggerFactory.getLogger(Common.class);

    public static boolean isValidColumnName(Column col) throws ParseException, IOException, ProcessingException {
        String currentLabel = OperationHelper.retrieveColumnLabel((Column)col);
        return Common.isValidString(currentLabel);
    }

    public static boolean isValidString(String str) throws ParseException, IOException, ProcessingException {
        return str.matches("^[a-z_][a-z_0-9]*") && !ReservedWordsDictionary.getDictionary().isReservedKeyWord(str);
    }

    public static String fixColumnName(String columnName) throws ParseException, IOException, ProcessingException {
        String toReturn = columnName.replaceAll("\\W", "_").toLowerCase();
        if (Common.isValidString(toReturn)) {
            return toReturn;
        }
        return "_" + toReturn;
    }

    public static String fixColumnName(String columnName, String ... additionalReservedWords) throws ParseException, IOException, ProcessingException {
        String toCheck = Common.fixColumnName(columnName);
        String[] stringArray = additionalReservedWords;
        int n = additionalReservedWords.length;
        int n2 = 0;
        while (n2 < n) {
            String additional = stringArray[n2];
            if (toCheck.equalsIgnoreCase(additional)) {
                toCheck = "_" + toCheck;
            }
            ++n2;
        }
        return toCheck;
    }

    public static String fixColumnName(Column col, String ... additionalReservedWords) throws ParseException, IOException, ProcessingException {
        return Common.fixColumnName(OperationHelper.retrieveColumnLabel((Column)col), additionalReservedWords);
    }

    public static Map<ColumnLocalId, String> curateLabels(Table table, String ... additionalReservedWords) throws ParseException, IOException, ProcessingException {
        HashMap<ColumnLocalId, String> toReturn = new HashMap<ColumnLocalId, String>();
        HashMap<String, Integer> clashCounter = new HashMap<String, Integer>();
        for (Column col : table.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
            String originalLabel = OperationHelper.retrieveColumnLabel((Column)col);
            String fixed = Common.fixColumnName(originalLabel, additionalReservedWords);
            if (clashCounter.containsKey(fixed)) {
                clashCounter.put(fixed, (Integer)clashCounter.get(fixed) + 1);
                fixed = String.valueOf(fixed) + "_" + clashCounter.get(fixed);
            } else {
                clashCounter.put(fixed, 1);
            }
            toReturn.put(col.getLocalId(), fixed);
        }
        return toReturn;
    }

    public static StatisticalManagerDataSpace getSMDataSpace() {
        return (StatisticalManagerDataSpace)StatisticalManagerDSL.dataSpace().build();
    }

    public static StatisticalManagerFactory getSMFactory() {
        return (StatisticalManagerFactory)StatisticalManagerDSL.createStateful().build();
    }

    public static boolean isSMAlgorithmAvailable(String algorithmId) {
        StatisticalManagerFactory factory = Common.getSMFactory();
        SMListGroupedAlgorithms groups = factory.getAlgorithms(new SMTypeParameter[0]);
        for (SMGroupedAlgorithms group : groups.thelist()) {
            for (SMAlgorithm algorithm : group.thelist()) {
                if (!algorithm.name().equals(algorithmId)) continue;
                return true;
            }
        }
        return false;
    }

    public static void handleSMResource(SMResource toHandle, List<ResourceDescriptorResult> results, Map<String, String> toSerializeValues, WorkerWrapper<DataWorker, WorkerResult> wrapper, boolean clearDataSpace, String user, Home home) throws WorkerException {
        try {
            int resourceTypeIndex = toHandle.resourceType();
            SMResourceType smResType = SMResourceType.values()[resourceTypeIndex];
            switch (smResType) {
                case FILE: {
                    SMFile smFile = (SMFile)toHandle;
                    MyFile f = Common.getStorageFileDescriptor(smFile.url());
                    results.add((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(f.getId()), Common.fileNameToMimeType(smFile.name())), smFile.description(), "-", ResourceType.GENERIC_FILE));
                    break;
                }
                case TABULAR: {
                    Table table = Common.importFromTableSpace((SMTable)toHandle, wrapper, clearDataSpace);
                    results.add((ResourceDescriptorResult)new ImmutableTableResource(new TableResource(table.getId()), OperationHelper.retrieveTableLabel((Table)table), "Imported from SM", ResourceType.GENERIC_TABLE));
                    break;
                }
                case OBJECT: {
                    SMObject objRes = (SMObject)toHandle;
                    if (objRes.name().contentEquals(PrimitiveTypes.MAP.toString())) {
                        for (Map.Entry<String, SMResource> entry : Common.asMap(objRes).entrySet()) {
                            SMResource res = entry.getValue();
                            res.description(entry.getKey());
                            Common.handleSMResource(res, results, toSerializeValues, wrapper, clearDataSpace, user, home);
                        }
                        break;
                    }
                    if (objRes.name().contentEquals(PrimitiveTypes.FILE.toString())) {
                        MyFile file = Common.getStorageFileDescriptor(objRes.url());
                        results.add((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(file.getId()), Common.fileNameToMimeType(objRes.name())), objRes.description(), "-", ResourceType.GENERIC_FILE));
                        break;
                    }
                    if (objRes.name().contentEquals(PrimitiveTypes.IMAGES.toString())) {
                        results.addAll(Common.getFilesUrlFromFolderUrl(objRes.url(), user, home));
                        break;
                    }
                    toSerializeValues.put(String.format("%s [%s]", objRes.description(), objRes.name()), objRes.url());
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unable to get resource " + toHandle, (Throwable)e);
        }
    }

    public static Map<String, SMResource> asMap(SMObject theMap) throws Exception {
        logger.debug("the url for map object is " + theMap.url());
        Object obj = null;
        try (InputStream is = null;){
            Map smMap;
            is = Common.getStorageClientInputStream(theMap.url());
            XStream xstream = new XStream();
            xstream.alias("org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMObject", SMObject.class);
            xstream.alias("org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMFile", SMFile.class);
            xstream.alias("org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMResource", SMResource.class);
            xstream.alias("org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTable", SMTable.class);
            obj = xstream.fromXML(is);
            Map map = smMap = (Map)obj;
            return map;
        }
    }

    private static Table importFromTableSpace(SMTable table, WorkerWrapper<DataWorker, WorkerResult> wrapper, boolean clearDataSpace) throws WorkerException, OperationAbortedException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(ImportFromStatisticalOperationFactory.RESOURCE_ID.getIdentifier(), table.resourceId());
            params.put(ImportFromStatisticalOperationFactory.RESOURCE_NAME.getIdentifier(), table.name());
            params.put(ImportFromStatisticalOperationFactory.DELETE_REMOTE_RESOURCE.getIdentifier(), clearDataSpace);
            WorkerStatus status = wrapper.execute(null, null, params);
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Failed export to dataspace");
            }
            return ((WorkerResult)wrapper.getResult()).getResultTable();
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to import table from dataspace.", (Throwable)e);
        }
    }

    private static List<ResourceDescriptorResult> getFilesUrlFromFolderUrl(String url, String user, Home home) throws WorkerException {
        try {
            ArrayList<ResourceDescriptorResult> toReturn = new ArrayList<ResourceDescriptorResult>();
            String callerScope = ScopeProvider.instance.get();
            ScopeBean scope = new ScopeBean(callerScope);
            while (!scope.is(ScopeBean.Type.INFRASTRUCTURE)) {
                scope = scope.enclosingScope();
            }
            ScopeProvider.instance.set(scope.toString());
            String HLServiceName = null;
            String HLPackage = "org.gcube.portlets.user";
            String HLResourceName = "HomeLibraryRepository";
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Category/text() eq 'Database' and $resource/Profile/Name eq '" + HLResourceName + "' ");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            for (ServiceEndpoint.AccessPoint ap : ((ServiceEndpoint)client.submit((Query)query).get(0)).profile().accessPoints()) {
                if (!ap.name().equals("ServiceName")) continue;
                HLServiceName = ap.address();
                break;
            }
            IClient storage = new StorageClient(HLPackage, HLServiceName, user, AccessType.SHARED, scope.toString(), true).getClient();
            Workspace ws = home.getWorkspace();
            WorkspaceItem folderItem = ws.getItemByPath(url);
            WorkspaceFolder folder = (WorkspaceFolder)folderItem;
            List childrenList = folder.getChildren();
            for (WorkspaceItem item : childrenList) {
                ExternalImage file = (ExternalImage)item;
                String name = item.getName();
                String mimeType = file.getMimeType();
                if (mimeType.equalsIgnoreCase("png")) {
                    mimeType = "image/png";
                }
                MyFile storageFile = storage.getMetaFile().RFile(file.getRemotePath());
                toReturn.add((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(storageFile.getId()), mimeType), name, item.getDescription(), ResourceType.GENERIC_FILE));
            }
            ScopeProvider.instance.set(callerScope);
            return toReturn;
        }
        catch (Exception e) {
            throw new WorkerException("Unable to retrieve results from workspace ", (Throwable)e);
        }
    }

    private static InputStream getStorageClientInputStream(String url) throws Exception {
        return new URL(url).openConnection().getInputStream();
    }

    private static MyFile getStorageFileDescriptor(String resourceUrl) throws RemoteBackendException, Exception {
        try {
            return Utils.getStorageClient().getMetaFile().RFile(resourceUrl);
        }
        catch (Exception e) {
            logger.debug("Not a valid file id " + resourceUrl + ", copying by stream");
            IClient client = Utils.getStorageClient();
            String id = client.put(true).LFile(Common.getStorageClientInputStream(resourceUrl)).RFile(UUID.randomUUID().toString());
            logger.debug("Copied to new id : " + id);
            return Utils.getStorageClient().getMetaFile().RFile(id);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String fileNameToMimeType(String fileName) {
        int n;
        try {
            String extension;
            String string = extension = fileName.substring(fileName.lastIndexOf(46) + 1);
            n = -1;
            switch (string.hashCode()) {
                case 98822: {
                    if (!string.equals("csv")) break;
                    n = 1;
                    break;
                }
                case 102340: {
                    if (!string.equals("gif")) break;
                    n = 2;
                    break;
                }
                case 111145: {
                    if (!string.equals("png")) break;
                    n = 3;
                    break;
                }
                case 115312: {
                    if (!string.equals("txt")) break;
                    n = 4;
                    break;
                }
                case 120609: {
                    if (!string.equals("zip")) break;
                    n = 5;
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.debug("Unable to understand file extension, name is " + fileName, (Throwable)e);
            return "";
        }
        {
        }
        switch (n) {
            case 5: {
                return "application/zip";
            }
            case 3: {
                return "image/png";
            }
            case 1: {
                return "text/csv";
            }
            case 2: {
                return "image/gif";
            }
            case 4: {
                return "text/plain";
            }
        }
        return "";
    }
}

