/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical.specific;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.csv4j.ParseException;
import net.sf.csv4j.ProcessingException;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.functions.Cast;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDNumeric;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.resources.TableResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.data.add.AddColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.statistical.Common;
import org.gcube.data.analysis.tabulardata.statistical.Constants;
import org.gcube.data.analysis.tabulardata.statistical.ExportToStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.specific.EnhanceLatLonFactory;
import org.gcube.data.analysis.tabulardata.statistical.specific.LatLongFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhanceLatLong
extends DataWorker {
    private static Logger logger = LoggerFactory.getLogger(EnhanceLatLong.class);
    private StatisticalOperationFactory statisticalFactory;
    private AddColumnFactory addColumnFactory;
    private CubeManager cubeManager;
    private Table targetTable;
    private Column latColumn;
    private Column longColumn;
    private Double precision;
    private LatLongFeature feature;
    private String userName;
    private Column quadrant;
    private boolean deleteRemote = false;
    private boolean deleteGenerated = false;
    private Map<String, Object> wrapperParameters = new HashMap<String, Object>();
    private Table generatedTable;
    private Table resultTable;
    private String exportedIdColumnLabel;
    private ColumnType importedColumnType;
    private Table enhancedTable;
    private String toEscapeColumnName = null;

    public EnhanceLatLong(OperationInvocation sourceInvocation, StatisticalOperationFactory statisticalFactory, AddColumnFactory addColumnFactory, CubeManager cubeManager) {
        super(sourceInvocation);
        this.statisticalFactory = statisticalFactory;
        this.addColumnFactory = addColumnFactory;
        this.cubeManager = cubeManager;
    }

    protected WorkerResult execute() throws WorkerException, OperationAbortedException {
        try {
            this.updateProgress(0.1f, "Initializing");
            this.init();
            this.updateProgress(0.2f, "Preparing data");
            this.prepareData();
            this.checkAborted();
            this.prepareSMParameters();
            this.updateProgress(0.3f, "Executing staistical algorithm");
            this.checkAborted();
            this.submitExecution();
            this.updateProgress(0.8f, "Merging result..");
            this.checkAborted();
            this.addColumn();
            return new ImmutableWorkerResult(this.resultTable);
        }
        catch (WorkerException e) {
            throw e;
        }
        catch (OperationAbortedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkerException("Unexpected internal error. Please contact support", (Throwable)e);
        }
    }

    private void init() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.importedColumnType = this.targetTable.getTableType().getAllowedColumnTypes().contains(new AnnotationColumnType()) ? new AnnotationColumnType() : new AttributeColumnType();
        this.latColumn = this.targetTable.getColumnById(((ColumnReference)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.LATITUDE_COLUMN_PARAM, (OperationInvocation)this.getSourceInvocation())).getColumnId());
        this.longColumn = this.targetTable.getColumnById(((ColumnReference)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.LONGITUTE_COLUMN_PARAM, (OperationInvocation)this.getSourceInvocation())).getColumnId());
        try {
            this.precision = ((TDNumeric)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.RESOLUTION_PARAM, (OperationInvocation)this.getSourceInvocation())).getValue();
        }
        catch (Throwable t) {
            this.precision = null;
        }
        try {
            this.quadrant = this.targetTable.getColumnById(((ColumnReference)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.QUADRANT_COLUMN_PARAMETER, (OperationInvocation)this.getSourceInvocation())).getColumnId());
        }
        catch (Throwable t) {
            this.quadrant = null;
        }
        this.feature = LatLongFeature.valueOf((String)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.TO_ADD_FEATURE_PARAM, (OperationInvocation)this.getSourceInvocation()));
        this.userName = (String)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.USER, (OperationInvocation)this.getSourceInvocation());
        try {
            this.deleteRemote = (Boolean)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.DELETE_REMOTE, (OperationInvocation)this.getSourceInvocation());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.deleteGenerated = (Boolean)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.DELETE_GENERATED, (OperationInvocation)this.getSourceInvocation());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        switch (this.feature) {
            case CSQUARECODE: {
                this.toEscapeColumnName = Constants.CSQUARE_CODE_COLUMN;
                break;
            }
            case OCEANAREA: {
                this.toEscapeColumnName = Constants.OCEAN_AREA_COLUMN;
            }
        }
    }

    private void prepareData() throws OperationAbortedException, WorkerException, ParseException, IOException, ProcessingException {
        Column idColumn = (Column)this.targetTable.getColumnsByType(new Class[]{IdColumnType.class}).get(0);
        this.exportedIdColumnLabel = Common.fixColumnName(idColumn.getLocalId().getValue());
        HashMap<String, Object> addColumnParameters = new HashMap<String, Object>();
        addColumnParameters.put(AddColumnFactory.COLUMN_TYPE.getIdentifier(), this.importedColumnType);
        addColumnParameters.put(AddColumnFactory.DATA_TYPE.getIdentifier(), idColumn.getDataType());
        addColumnParameters.put(AddColumnFactory.LABEL.getIdentifier(), new ImmutableLocalizedText(idColumn.getLocalId().getValue()));
        addColumnParameters.put(AddColumnFactory.VALUE_PARAMETER.getIdentifier(), this.targetTable.getColumnReference(idColumn));
        WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.addColumnFactory);
        try {
            WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, addColumnParameters);
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Failed to prepare data : " + status);
            }
            this.enhancedTable = ((WorkerResult)wrapper.getResult()).getResultTable();
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to prepare data", (Throwable)e);
        }
    }

    private void prepareSMParameters() throws ParseException, IOException, ProcessingException {
        this.wrapperParameters.put(StatisticalOperationFactory.USER.getIdentifier(), this.userName);
        this.wrapperParameters.put(StatisticalOperationFactory.CLEAR_DATASPACE.getIdentifier(), this.deleteGenerated);
        this.wrapperParameters.put(StatisticalOperationFactory.REMOVE_EXPORTED.getIdentifier(), this.deleteRemote);
        HashMap<String, String> algorithmParameters = new HashMap<String, String>();
        switch (this.feature) {
            case CSQUARECODE: {
                this.wrapperParameters.put(StatisticalOperationFactory.ALGORITHM.getIdentifier(), Constants.CSQUARE_ALGORITHM);
                this.wrapperParameters.put(ExportToStatisticalOperationFactory.toEscapeFieldNamesParam.getIdentifier(), Constants.CSQUARE_CODE_COLUMN);
                algorithmParameters.put("InputTable", this.enhancedTable.getId().toString());
                algorithmParameters.put("Longitude_Column", Common.fixColumnName(this.longColumn, new String[0]));
                algorithmParameters.put("Latitude_Column", Common.fixColumnName(this.latColumn, new String[0]));
                algorithmParameters.put("CSquare_Resolution", String.valueOf(this.precision != null ? this.precision : (double)new Float(0.1).floatValue()));
                algorithmParameters.put("OutputTableName", "csquare_");
                break;
            }
            case OCEANAREA: {
                this.wrapperParameters.put(ExportToStatisticalOperationFactory.toEscapeFieldNamesParam.getIdentifier(), Constants.OCEAN_AREA_COLUMN);
                if (this.quadrant == null) {
                    this.wrapperParameters.put(StatisticalOperationFactory.ALGORITHM.getIdentifier(), Constants.OCEAN_AREA_ALGORITHM);
                } else {
                    this.wrapperParameters.put(StatisticalOperationFactory.ALGORITHM.getIdentifier(), Constants.OCEAN_AREA_QUADRANT_ALGORITHM);
                    algorithmParameters.put("Quadrant_Column", Common.fixColumnName(this.quadrant, new String[0]));
                }
                algorithmParameters.put("InputTable", this.enhancedTable.getId().toString());
                algorithmParameters.put("Longitude_Column", Common.fixColumnName(this.longColumn, new String[0]));
                algorithmParameters.put("Latitude_Column", Common.fixColumnName(this.latColumn, new String[0]));
                algorithmParameters.put("OutputTableName", "ocean_");
                Integer resolution = this.precision != null ? (this.precision > 0.0 ? this.precision.intValue() : 1) : 1;
                algorithmParameters.put("Resolution", resolution.toString());
            }
        }
        this.wrapperParameters.put(StatisticalOperationFactory.SM_ENTRIES.getIdentifier(), algorithmParameters);
    }

    private void submitExecution() throws OperationAbortedException, WorkerException {
        block5: {
            WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.statisticalFactory);
            try {
                WorkerStatus status = wrapper.execute(this.enhancedTable.getId(), null, this.wrapperParameters);
                if (status.equals((Object)WorkerStatus.SUCCEDED)) {
                    for (ResourceDescriptorResult result : ((ResourcesResult)wrapper.getResult()).getResources()) {
                        if (!result.getResourceType().equals((Object)ResourceType.GENERIC_TABLE)) continue;
                        this.generatedTable = this.cubeManager.getTable(((TableResource)result.getResource()).getTableId());
                    }
                    if (this.generatedTable == null) {
                        throw new WorkerException("No tables were generated by submitted computation");
                    }
                    break block5;
                }
                throw new WorkerException("Failed algorithm execution, internal status is :" + status);
            }
            catch (InvalidInvocationException e) {
                logger.debug("Unable to submit to SM : ", (Throwable)e);
                throw new WorkerException("Unable to submit computation, " + e.getMessage());
            }
        }
        this.cubeManager.removeTable(this.enhancedTable.getId());
    }

    private void addColumn() throws WorkerException, OperationAbortedException, ParseException, IOException, ProcessingException {
        block6: {
            Column generatedCol = null;
            Column externalIdColumn = null;
            Collection<String> curatedLabels = Common.curateLabels(this.targetTable, this.toEscapeColumnName).values();
            for (Column externalCol : this.generatedTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
                boolean isGenerated = true;
                String externalLabel = OperationHelper.retrieveColumnLabel((Column)externalCol);
                if (externalLabel.equalsIgnoreCase(this.exportedIdColumnLabel)) {
                    externalIdColumn = externalCol;
                    continue;
                }
                if (curatedLabels.contains(externalLabel)) {
                    isGenerated = false;
                    continue;
                }
                generatedCol = externalCol;
            }
            Column localId = (Column)this.targetTable.getColumnsByType(new Class[]{IdColumnType.class}).get(0);
            Equals condition = new Equals((Expression)this.targetTable.getColumnReference(localId), (Expression)new Cast((Expression)this.generatedTable.getColumnReference(externalIdColumn), localId.getDataType()));
            HashMap<String, Object> addColumnParameters = new HashMap<String, Object>();
            addColumnParameters.put(AddColumnFactory.COLUMN_TYPE.getIdentifier(), this.importedColumnType);
            addColumnParameters.put(AddColumnFactory.DATA_TYPE.getIdentifier(), generatedCol.getDataType());
            addColumnParameters.put(AddColumnFactory.LABEL.getIdentifier(), new ImmutableLocalizedText(String.valueOf(OperationHelper.retrieveColumnLabel((Column)generatedCol)) + (this.precision != null ? this.precision : "")));
            addColumnParameters.put(AddColumnFactory.VALUE_PARAMETER.getIdentifier(), this.generatedTable.getColumnReference(generatedCol));
            addColumnParameters.put(AddColumnFactory.CONDITION_PARAMETER.getIdentifier(), condition);
            WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.addColumnFactory);
            try {
                WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, addColumnParameters);
                if (status.equals((Object)WorkerStatus.SUCCEDED)) {
                    this.resultTable = ((WorkerResult)wrapper.getResult()).getResultTable();
                    break block6;
                }
                throw new WorkerException("Unexpected worker status while adding column : " + status);
            }
            catch (InvalidInvocationException e) {
                throw new WorkerException("Unable to add generatedColumn", (Throwable)e);
            }
        }
        this.cubeManager.removeTable(this.generatedTable.getId());
    }
}

