/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.util.HashMap;
import java.util.Map;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDSL;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMTypeParameter;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;

public class Common {
    public static boolean isValidColumnName(Column col) {
        String currentLabel = OperationHelper.retrieveColumnLabel((Column)col);
        return Common.isValidString(currentLabel);
    }

    public static boolean isValidString(String str) {
        return str.matches("^[a-z][a-z_0-9]*");
    }

    public static String fixColumnName(String columnName) {
        return columnName.replaceAll("\\W", "_").toLowerCase();
    }

    public static String fixColumnName(Column col) {
        return Common.fixColumnName(OperationHelper.retrieveColumnLabel((Column)col));
    }

    public static Map<ColumnLocalId, String> curateLabels(Table table) {
        HashMap<ColumnLocalId, String> toReturn = new HashMap<ColumnLocalId, String>();
        HashMap<String, Integer> clashCounter = new HashMap<String, Integer>();
        for (Column col : table.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
            String originalLabel = OperationHelper.retrieveColumnLabel((Column)col);
            String fixed = Common.fixColumnName(originalLabel);
            if (clashCounter.containsKey(fixed)) {
                clashCounter.put(fixed, (Integer)clashCounter.get(fixed) + 1);
                fixed = String.valueOf(fixed) + "_" + clashCounter.get(fixed);
            } else {
                clashCounter.put(fixed, 1);
            }
            toReturn.put(col.getLocalId(), fixed);
        }
        return toReturn;
    }

    public static StatisticalManagerDataSpace getSMDataSpace() {
        return (StatisticalManagerDataSpace)StatisticalManagerDSL.dataSpace().build();
    }

    public static StatisticalManagerFactory getSMFactory() {
        return (StatisticalManagerFactory)StatisticalManagerDSL.createStateful().build();
    }

    public static boolean isSMAlgorithmAvailable(String algorithmId) {
        StatisticalManagerFactory factory = Common.getSMFactory();
        SMListGroupedAlgorithms groups = factory.getAlgorithms(new SMTypeParameter[0]);
        for (SMGroupedAlgorithms group : groups.thelist()) {
            for (SMAlgorithm algorithm : group.thelist()) {
                if (!algorithm.name().equals(algorithmId)) continue;
                return true;
            }
        }
        return false;
    }
}

