/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputationConfig;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMAbstractResource;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMComputation;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMEntries;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMFile;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMInputEntry;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMObject;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMOperationInfo;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMResource;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMTable;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ExportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GenericMapMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.statistical.ExportToStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.ImportFromStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperationFactory;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;

public class StatisticalOperation
extends Worker {
    private StatisticalManagerDataSpace statisticalDataSpace;
    private StatisticalManagerFactory statisticalManagerFactory;
    private ExportToStatisticalOperationFactory exportFactory;
    private ImportFromStatisticalOperationFactory importFactory;
    private Home home;
    private CubeManager cubeManager;
    private Map<String, Object> algorithmParameters;
    private String user;
    private String algorithmId;
    private String experimentTitle = null;
    private String experimentDescription = null;
    private Table targetTable;
    private String dataSpaceTableId;
    private Table resultTable;
    private ArrayList<Table> collaterals = new ArrayList();
    String computationId;

    public StatisticalOperation(OperationInvocation sourceInvocation, StatisticalManagerDataSpace statisticalDataSpace, StatisticalManagerFactory statisticalManagerFactory, ExportToStatisticalOperationFactory exportFactory, ImportFromStatisticalOperationFactory importFactory, Home home, CubeManager cubeManager) {
        super(sourceInvocation);
        this.statisticalDataSpace = statisticalDataSpace;
        this.statisticalManagerFactory = statisticalManagerFactory;
        this.exportFactory = exportFactory;
        this.importFactory = importFactory;
        this.home = home;
        this.cubeManager = cubeManager;
    }

    protected WorkerResult execute() throws WorkerException {
        this.getParameters();
        this.updateProgress(0.05f);
        this.importIntoDataSpace();
        this.updateProgress(0.2f);
        this.submitComputation();
        this.waitForComputation();
        this.generateTableFromResult();
        if (this.collaterals.size() > 0) {
            return new ImmutableWorkerResult(this.resultTable, this.collaterals);
        }
        return new ImmutableWorkerResult(this.resultTable);
    }

    public void getParameters() {
        Map params = this.getSourceInvocation().getParameterInstances();
        this.algorithmParameters = (Map)params.get(StatisticalOperationFactory.SM_ENTRIES.getIdentifier());
        this.user = (String)params.get(StatisticalOperationFactory.USER.getIdentifier());
        this.algorithmId = (String)params.get(StatisticalOperationFactory.ALGORITHM.getIdentifier());
        if (params.containsKey(StatisticalOperationFactory.TITLE.getIdentifier())) {
            this.experimentTitle = (String)params.get(StatisticalOperationFactory.TITLE.getIdentifier());
        }
        if (params.containsKey(StatisticalOperationFactory.DESCRIPTION.getIdentifier())) {
            this.experimentDescription = (String)params.get(StatisticalOperationFactory.DESCRIPTION.getIdentifier());
        }
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
    }

    public void submitComputation() {
        SMComputationRequest request = new SMComputationRequest();
        SMComputationConfig config = new SMComputationConfig();
        ArrayList<SMInputEntry> entryList = new ArrayList<SMInputEntry>();
        for (Map.Entry<String, Object> mapEntry : this.algorithmParameters.entrySet()) {
            if (((String)mapEntry.getValue()).equals(this.targetTable.getId().toString())) {
                entryList.add(new SMInputEntry(mapEntry.getKey(), this.dataSpaceTableId));
                continue;
            }
            entryList.add(new SMInputEntry(mapEntry.getKey(), mapEntry.getValue().toString()));
        }
        config.parameters(new SMEntries(entryList.toArray(new SMInputEntry[entryList.size()])));
        config.algorithm(this.algorithmId);
        request.user(this.user);
        request.title(this.experimentTitle == null ? this.algorithmId : this.experimentTitle);
        request.description(this.experimentDescription == null ? "Submission via TDM" : this.experimentDescription);
        request.config(config);
        this.computationId = this.statisticalManagerFactory.executeComputation(request);
    }

    public void waitForComputation() throws WorkerException {
        boolean complete = false;
        while (!complete) {
            SMComputation computation = this.statisticalManagerFactory.getComputation(this.computationId);
            SMOperationStatus status = SMOperationStatus.values()[computation.operationStatus()];
            switch (status) {
                case FAILED: {
                    throw new WorkerException("Failed Experiment.");
                }
                case COMPLETED: {
                    complete = true;
                    break;
                }
                default: {
                    SMOperationInfo infos = this.statisticalManagerFactory.getComputationInfo(this.computationId, this.user);
                    float smPercent = Float.parseFloat(infos.percentage()) / 100.0f;
                    this.updateProgress(0.1f + smPercent * 0.8f);
                    try {
                        Thread.sleep(5000L);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void generateTableFromResult() throws WorkerException {
        SMComputation computation = this.statisticalManagerFactory.getComputation(this.computationId);
        SMAbstractResource abstractResource = computation.abstractResource();
        SMResource smResource = abstractResource.resource();
        HashMap<String, String> metaMap = new HashMap<String, String>();
        this.handleSMResource(smResource, metaMap, this.collaterals);
        this.resultTable = metaMap.size() > 0 ? this.cubeManager.modifyTableMeta(this.targetTable.getId()).setTableMetadata(new TableMetadata[]{new GenericMapMetadata(metaMap)}).create() : this.targetTable;
    }

    private Table importFromTableSpace(SMTable table) throws WorkerException {
        WorkerWrapper wrapper = new WorkerWrapper((WorkerFactory)this.importFactory);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(ImportFromStatisticalOperationFactory.RESOURCE_ID.getIdentifier(), table.resourceId());
            WorkerStatus status = wrapper.execute(null, null, this.getSourceInvocation().getParameterInstances());
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Failed export to dataspace");
            }
            return wrapper.getResult().getResultTable();
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to export table to dataspace.", (Throwable)e);
        }
    }

    private void handleSMResource(SMResource toHandle, Map<String, String> links, List<Table> tables) throws WorkerException {
        int resourceTypeIndex = toHandle.resourceType();
        SMResourceType smResType = SMResourceType.values()[resourceTypeIndex];
        switch (smResType) {
            case FILE: {
                SMFile smFile = (SMFile)toHandle;
                links.put(smFile.name(), smFile.url());
                break;
            }
            case OBJECT: {
                SMObject smObject = (SMObject)toHandle;
                if (smObject.name().contentEquals(PrimitiveTypes.MAP.toString())) {
                    links.putAll(this.getFilesUrlFromFolderUrl(smObject.url()));
                    break;
                }
                links.put(smObject.name(), smObject.url());
                break;
            }
            case TABULAR: {
                tables.add(this.importFromTableSpace((SMTable)toHandle));
            }
        }
    }

    private Table addMapMetadata(Table toEnrich, Map<String, String> theMap) {
        TableMetaCreator tmc = this.cubeManager.modifyTableMeta(toEnrich.getId());
        tmc.setTableMetadata(new TableMetadata[]{new GenericMapMetadata(theMap)});
        return tmc.create();
    }

    private void importIntoDataSpace() throws WorkerException {
        WorkerWrapper wrapper = new WorkerWrapper((WorkerFactory)this.exportFactory);
        try {
            WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, this.getSourceInvocation().getParameterInstances());
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Failed export to dataspace");
            }
            this.dataSpaceTableId = ((ExportMetadata)wrapper.getResult().getResultTable().getMetadata(ExportMetadata.class)).getUri();
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to export table to dataspace.", (Throwable)e);
        }
        catch (NoSuchMetadataException e) {
            throw new WorkerException("Unable to get dataspace table id for exported table", (Throwable)e);
        }
    }

    private Map<String, String> getFilesUrlFromFolderUrl(String url) throws WorkerException {
        try {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            Workspace ws = this.home.getWorkspace();
            WorkspaceItem folderItem = ws.getItemByPath(url);
            WorkspaceFolder folder = (WorkspaceFolder)folderItem;
            List childrenList = folder.getChildren();
            for (WorkspaceItem item : childrenList) {
                ExternalImage file = (ExternalImage)item;
                String name = item.getName();
                String absoluteUrlFile = file.getPublicLink();
                map.put(name, absoluteUrlFile);
            }
            return map;
        }
        catch (Exception e) {
            throw new WorkerException("Unable to retrieve results from workspace ", (Throwable)e);
        }
    }
}

