/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.executors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.data.analysis.sdmx.DataInformationProvider;
import org.gcube.data.analysis.tabulardata.model.metadata.common.TableDescriptorMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.sdmx.configuration.ConfigurationManager;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.DataStructureDefinitionWorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.SDMXDataOperationExecutor;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.beans.SDMXDataBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.beans.SDMXDataResultBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.beans.TableBean;
import org.gcube.datapublishing.sdmx.DataSourceInformationProvider;
import org.gcube.datapublishing.sdmx.RegistryInformationProvider;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXVersionException;
import org.gcube.datapublishing.sdmx.model.DataSource;
import org.gcube.datapublishing.sdmx.security.model.impl.BasicCredentials;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.mutable.base.DataProviderSchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.DataProviderMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TextTypeWrapperMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.ProvisionAgreementMutableBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXDataStructurePublisher
implements SDMXDataOperationExecutor {
    private final String OPERATION_NAME = "Publishing";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final String CODELIST_VERSION_ACTION_PROPERTY = "codelist.version.action";
    private boolean primary;

    public SDMXDataStructurePublisher(boolean isPrimary) {
        this.primary = isPrimary;
    }

    @Override
    public String getOperationName() {
        return "Publishing";
    }

    private String getTabularResourceId(Table table) {
        this.log.debug("Getting tabular resource id");
        String response = null;
        try {
            TableDescriptorMetadata metadata = (TableDescriptorMetadata)table.getMetadata(TableDescriptorMetadata.class);
            response = String.valueOf(metadata.getRefId());
            this.log.debug("Tabular resource id " + response);
        }
        catch (RuntimeException e) {
            this.log.error("Unable to get tabular resource id", (Throwable)e);
        }
        return response;
    }

    private DataProviderBean getDataSource(SDMXRegistryClient registryClient, String dataFlowAgency) {
        this.log.debug("Checking data sources and registrations");
        DataSource dataSource = DataSourceInformationProvider.getDataSource();
        DataProviderBean response = null;
        if (dataSource == null) {
            this.log.debug("No Data Source found for this VRE: data will not be exported");
        } else {
            this.log.debug("Data Source found");
            try {
                SdmxBeans dataProviderSchemeBean = registryClient.getDataProviderScheme(dataFlowAgency, "", "", SDMXRegistryClient.Detail.full, SDMXRegistryClient.References.none);
                Set dataProviderSchemas = dataProviderSchemeBean.getDataProviderSchemes();
                Iterator dataProviderSchemeIterator = dataProviderSchemas.iterator();
                this.log.debug("Found " + dataProviderSchemas.size() + " schemas");
                if (dataProviderSchemeIterator.hasNext()) {
                    DataProviderSchemeBean dataProviderScheme = (DataProviderSchemeBean)dataProviderSchemeIterator.next();
                    this.log.debug("Data provider scheme found " + dataProviderScheme.getId());
                    List dataProviders = dataProviderScheme.getItems();
                    this.log.debug("Data providers " + dataProviders.size());
                    Iterator dataProvidersIterator = dataProviders.iterator();
                    this.log.debug("Data providr");
                    while (dataProvidersIterator.hasNext() && response == null) {
                        DataProviderBean dataProvider = (DataProviderBean)dataProvidersIterator.next();
                        this.log.debug("Data Provider ID " + dataProvider.getId());
                        if (!dataSource.getName().equals(dataProvider.getId())) continue;
                        this.log.debug("Data Provider found");
                        response = dataProvider;
                    }
                    if (response == null) {
                        this.log.debug("Unable to find a suitable data provider");
                        this.log.debug("Creating...");
                        DataProviderMutableBeanImpl dataProviderMutableBean = new DataProviderMutableBeanImpl();
                        dataProviderMutableBean.setId(dataSource.getName());
                        ArrayList names = Lists.newArrayList();
                        names.add(new TextTypeWrapperMutableBeanImpl("en", dataSource.getName()));
                        dataProviderMutableBean.setNames((List)names);
                        DataProviderSchemeMutableBean dataProviderSchemeMutable = dataProviderScheme.getMutableInstance();
                        dataProviderSchemeMutable.addItem((ItemMutableBean)dataProviderMutableBean);
                        DataProviderSchemeBean updatedDataProviderScheme = dataProviderSchemeMutable.getImmutableInstance();
                        registryClient.publish(updatedDataProviderScheme, false);
                        this.log.debug("New Data Provider added");
                        response = (DataProviderBean)updatedDataProviderScheme.getItems().get(updatedDataProviderScheme.getItems().size() - 1);
                    }
                }
            }
            catch (SDMXRegistryClientException e) {
                this.log.debug("Unable to check Data Sources Registrations on the registry: data will not be exported", (Throwable)e);
            }
        }
        return response;
    }

    private void defineProvisionAgreement(DataProviderBean dataProvider, SDMXRegistryClient registryClient, DataflowBean dataFlow, SDMXDataResultBean result) {
        this.log.debug("Defining a provision agreement");
        try {
            this.log.debug("Defining provision agreement");
            ProvisionAgreementMutableBeanImpl provisionAgreement = new ProvisionAgreementMutableBeanImpl();
            provisionAgreement.setAgencyId(dataFlow.getAgencyId());
            provisionAgreement.setVersion(dataFlow.getVersion());
            provisionAgreement.setId(dataFlow.getId());
            ArrayList<TextTypeWrapperMutableBeanImpl> names = new ArrayList<TextTypeWrapperMutableBeanImpl>();
            for (TextTypeWrapper ttw : dataFlow.getNames()) {
                this.log.debug("Adding dataflow name " + ttw);
                names.add(new TextTypeWrapperMutableBeanImpl(ttw));
            }
            provisionAgreement.setNames(names);
            provisionAgreement.setDataproviderRef(dataProvider.asReference());
            provisionAgreement.setStructureUsage(dataFlow.asReference());
            this.log.debug("Provision agreement defined");
            registryClient.publish(provisionAgreement.getImmutableInstance());
        }
        catch (SDMXRegistryClientException e) {
            this.log.error("Unable to publish the new provision agreement", (Throwable)e);
            result.addMessage("Unable to publish the new provision agreement: " + e.getMessage());
        }
    }

    @Override
    public SDMXDataResultBean executeOperation(SDMXDataBean inputData, OperationInvocation invocation) {
        this.log.debug("Executing SDMX publishing");
        String tabularResourceID = this.getTabularResourceId(inputData.getTableBean().getTable());
        String registryUrl = (String)invocation.getParameterInstances().get("registryBaseUrl");
        BasicCredentials credentials = RegistryInformationProvider.retrieveCredentials((String)registryUrl);
        SDMXRegistryClient registryClient = DataStructureDefinitionWorkerUtils.initSDMXClient(registryUrl, credentials.getUsername(), credentials.getPassword());
        String currentType = null;
        SDMXDataResultBean result = new SDMXDataResultBean();
        try {
            this.log.debug("Publishing associated codelists...");
            currentType = "codelists";
            for (CodelistBean codelist : inputData.getAllCodelists()) {
                try {
                    this.log.debug("Publishing codelist " + codelist.getId());
                    registryClient.publish(codelist);
                    this.log.debug("Codelist published");
                }
                catch (SDMXVersionException e) {
                    switch (this.checkCodelistVersionAction()) {
                        case BLOCK: {
                            this.log.error("Codelist invalid version action: BLOCK. Abort: sending error message");
                            result.setError(this.primary);
                            result.addMessage("Invalid codelist version");
                            result.setException(e);
                            return result;
                        }
                        case WARNING: {
                            this.log.warn("Codelist invalid version action: WARNING. Sending warning message");
                            result.addMessage(e.getMessage());
                        }
                    }
                    this.log.warn(e.getMessage(), (Throwable)e);
                }
            }
            this.log.debug("Operation on codelists completed");
            currentType = "concepts";
            this.log.debug("Publishing concepts...");
            registryClient.publish(inputData.getConcepts().getImmutableInstance());
            this.log.debug("Concepts published");
            currentType = "data structure definitions";
            this.log.debug("Publishing dsd...");
            registryClient.publish(inputData.getDsd().getImmutableInstance());
            this.log.debug("DSD published");
            currentType = "data flow";
            this.log.debug("Publishing data flow...");
            DataflowBean dataFlow = inputData.getDataFlow().getImmutableInstance();
            registryClient.publish(dataFlow);
            this.log.debug("Data flow published");
            DataProviderBean dataProvider = this.getDataSource(registryClient, dataFlow.getAgencyId());
            if (dataProvider == null) {
                this.log.warn("Unable to find a suitable data provider on the registry: data will not be exported");
                result.addMessage("Data Provider not found");
            } else {
                this.log.debug("Data provider found");
                this.defineProvisionAgreement(dataProvider, registryClient, dataFlow, result);
                this.log.debug("Updating dataflow-table association on the Information System");
                this.registerIdsOnInformationSystem(result, dataProvider.getId(), tabularResourceID, inputData.getTableBean(), dataFlow.getAgencyId(), dataFlow.getId(), dataFlow.getVersion());
                this.log.debug("Operation completed");
            }
        }
        catch (SDMXVersionException e) {
            this.log.error("Version error in the pubblication of " + currentType, (Throwable)e);
            result.setError(this.primary);
            result.addMessage("Version error in the pubblication of " + currentType);
            result.setException(e);
        }
        catch (SDMXRegistryClientException e) {
            this.log.error("SDMX Client error in the pubblication of " + currentType, (Throwable)e);
            result.setError(this.primary);
            result.addMessage("SDMX Client error in the pubblication of " + currentType);
            result.setException(e);
        }
        return result;
    }

    private void registerIdsOnInformationSystem(SDMXDataResultBean result, String dataSourceId, String tabularResourceID, TableBean tableBean, String dataFlowAgency, String dataFlowId, String dataFlowVersion) {
        this.log.debug("Registering new dataflow on the Information System");
        String dataFlowkey = DataInformationProvider.getDataFlowKey((String)dataFlowAgency, (String)dataFlowId, (String)dataFlowVersion);
        String tableID = String.valueOf(tableBean.getTable().getId().getValue());
        if (DataInformationProvider.getInstance().addNewAssociation(dataSourceId, dataFlowkey, tabularResourceID, tableID, tableBean.getTimeDimensionColumn().getColumn().getLocalId().getValue(), tableBean.getPrimaryMeasure().getColumn().getLocalId().getValue())) {
            this.log.debug("Association updated on the Information System");
        } else {
            this.log.error("Unable to update the association");
            result.addMessage("Unable to upload data on the Information System: data source could not be available");
        }
    }

    private CODELIST_ACTIONS checkCodelistVersionAction() {
        String actionParameter = ConfigurationManager.getInstance().getValue("codelist.version.action");
        this.log.debug("Codelist action parameter " + actionParameter);
        if (actionParameter == null || CODELIST_ACTIONS.BLOCK.equals(actionParameter)) {
            return CODELIST_ACTIONS.BLOCK;
        }
        if (CODELIST_ACTIONS.WARNING.equals(actionParameter)) {
            return CODELIST_ACTIONS.WARNING;
        }
        return CODELIST_ACTIONS.IGNORE;
    }

    @Override
    public boolean isPrimaryOperation() {
        return this.primary;
    }

    @Override
    public boolean isDataAware() {
        return false;
    }

    private static enum CODELIST_ACTIONS {
        BLOCK("block"),
        WARNING("warning"),
        IGNORE("ignore");

        private String action;

        private CODELIST_ACTIONS(String action) {
            this.action = action;
        }

        public boolean equals(String actionString) {
            return this.action.equalsIgnoreCase(actionString);
        }

        public String toString() {
            return this.action;
        }
    }
}

