/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.types.formats;

import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.types.formats.GenericDataFormatGenerator;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.types.formats.data.DataFormatGeneratorData;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.types.formats.metadata.DataFormatGeneratorMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFormatGeneratorFactory {
    public static DataFormatGeneratorData getDataFormatGeneratorData(String typeDataFormatName) {
        Logger logger = LoggerFactory.getLogger(DataFormatGeneratorFactory.class);
        DataFormatGeneratorData response = null;
        if (typeDataFormatName == null) {
            logger.debug("Data type not found: using generic instance");
            response = new GenericDataFormatGenerator();
        } else {
            logger.debug("Data format found " + typeDataFormatName);
            try {
                Class<?> className = Class.forName(typeDataFormatName);
                response = (DataFormatGeneratorData)className.newInstance();
            }
            catch (Exception e) {
                logger.error("Class " + typeDataFormatName + " not found, using generic type", (Throwable)e);
                response = new GenericDataFormatGenerator();
            }
        }
        return response;
    }

    public static DataFormatGeneratorMetadata getDataFormatGeneratorMetadata(String typeDataFormatName) {
        Logger logger = LoggerFactory.getLogger(DataFormatGeneratorFactory.class);
        DataFormatGeneratorMetadata response = null;
        if (typeDataFormatName == null) {
            logger.debug("Data type not found: using generic instance");
            response = new GenericDataFormatGenerator();
        } else {
            logger.debug("Data format found " + typeDataFormatName);
            try {
                Class<?> className = Class.forName(typeDataFormatName);
                response = (DataFormatGeneratorMetadata)className.newInstance();
            }
            catch (Exception e) {
                logger.error("Class " + typeDataFormatName + " not found, using generic type", (Throwable)e);
                response = new GenericDataFormatGenerator();
            }
        }
        return response;
    }
}

