/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.codelist;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.metadata.common.TableDescriptorMetadata;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.resources.SDMXResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.sdmx.WorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.sdmx.agencies.AgencyProvider;
import org.gcube.data.analysis.tabulardata.operation.sdmx.agencies.exceptions.AgencyException;
import org.gcube.data.analysis.tabulardata.operation.sdmx.codelist.SDMXCodelistGenerator;
import org.gcube.data.analysis.tabulardata.operation.sdmx.configuration.ConfigurationManager;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableSDMXResource;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.datapublishing.sdmx.RegistryInformationProvider;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.gcube.datapublishing.sdmx.security.model.impl.BasicCredentials;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodelistMutableBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXCodelistExporter
extends ResourceCreatorWorker {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Table table;
    private OperationInvocation invocation;
    private DatabaseConnectionProvider connectionProvider;
    private String targetUrl;
    private String targetId;
    private String username;
    private String password;
    private final String errorMessage = "Unable to complete codelist export procedure";
    private boolean codelistVersionUser;
    private final String CODELIST_VERSION_USER = "codelist.version.user";

    public SDMXCodelistExporter(Table table, OperationInvocation invocation, DatabaseConnectionProvider connectionProvider) {
        super(invocation);
        this.table = table;
        this.invocation = invocation;
        this.connectionProvider = connectionProvider;
        this.username = null;
        this.password = null;
        String codelistVersionUserString = ConfigurationManager.getInstance().getValue("codelist.version.user");
        this.codelistVersionUser = codelistVersionUserString != null && codelistVersionUserString.equalsIgnoreCase("true");
    }

    protected ResourcesResult execute() throws WorkerException {
        try {
            this.retrieveParameters();
            TableDescriptorMetadata tableDescriptorMetadata = (TableDescriptorMetadata)this.table.getMetadata(TableDescriptorMetadata.class);
            String targetAgency = this.getTargetAgency(tableDescriptorMetadata);
            String targetVersion = this.getTargetVersion(tableDescriptorMetadata);
            SDMXCodelistGenerator codelistGenerator = new SDMXCodelistGenerator(this.table, this.connectionProvider, targetAgency, this.targetId, targetVersion);
            this.updateProgress(0.1f, "Creating beans");
            CodelistMutableBean codelist = codelistGenerator.createBaseCodelistBean();
            this.updateProgress(0.2f, "Populating codelist");
            codelistGenerator.populateCodelistWithCodes(codelist);
            this.updateProgress(0.6f, "Publishing");
            this.publishCodelist(codelist);
            this.updateProgress(0.8f, "Finalizing");
            SDMXResource sdmxResource = new SDMXResource(new URL(WorkerUtils.getResourceURI(this.targetUrl)), this.targetId, targetVersion, targetAgency, SDMXResource.TYPE.CODE_LIST);
            return new ResourcesResult((ResourceDescriptorResult)new ImmutableSDMXResource(sdmxResource, "Codelist SDMX export", sdmxResource.toString(), ResourceType.SDMX));
        }
        catch (RuntimeException e) {
            this.log.error("Unable to complete codelist export procedure", (Throwable)e);
            throw new WorkerException("Unable to complete codelist export procedure", (Throwable)e);
        }
        catch (SQLException e) {
            this.log.error("Unable to complete codelist export procedure", (Throwable)e);
            throw new WorkerException("Unable to complete codelist export procedure", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new WorkerException(String.format("exported url %s not valid", this.targetUrl), (Throwable)e);
        }
    }

    private void retrieveParameters() {
        this.targetUrl = (String)this.invocation.getParameterInstances().get("registryBaseUrl");
        this.targetId = (String)this.invocation.getParameterInstances().get("id");
        BasicCredentials credentials = RegistryInformationProvider.retrieveCredentials((String)this.targetUrl);
        this.username = credentials.getUsername();
        this.password = credentials.getPassword();
    }

    private String getTargetAgency(TableDescriptorMetadata metadata) {
        String userAgency = (String)this.invocation.getParameterInstances().get("agency");
        if (metadata != null) {
            try {
                return AgencyProvider.getInstance().getAgency(metadata.getAgency(), userAgency, new String[]{this.targetUrl, this.username, this.password});
            }
            catch (AgencyException e) {
                this.log.error("Unable contact the registry to manage agencies", (Throwable)e);
            }
        }
        return userAgency;
    }

    private String getTargetVersion(TableDescriptorMetadata metadata) {
        if (metadata != null && !this.codelistVersionUser) {
            String metadataVersion = metadata.getVersion();
            this.log.debug("Table version = " + metadataVersion);
            return metadataVersion;
        }
        return (String)this.invocation.getParameterInstances().get("version");
    }

    private void publishCodelist(CodelistMutableBean codelist) throws WorkerException {
        String url = (String)this.invocation.getParameterInstances().get("registryBaseUrl");
        this.log.debug("Publishing data in " + url);
        SDMXRegistryClient registryClient = WorkerUtils.initSDMXClient(url, this.username, this.password);
        this.log.debug("SDMX client intialized");
        try {
            this.log.debug("Generating immutable instance");
            CodelistBean codeList = codelist.getImmutableInstance();
            this.log.debug("Immutable instance generated");
            registryClient.publish(codeList);
            this.log.debug("Codelist publised");
        }
        catch (SDMXRegistryClientException e) {
            this.log.error("Unable to publish codelist on registry", (Throwable)e);
            throw new WorkerException("Unable to publish codelist on registry.", (Throwable)e);
        }
    }
}

