/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.beans;

import java.util.List;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.beans.DataStructureBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.beans.DataColumnBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.beans.TableBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptMutableBean;

public class ExcelDataStructureBean
extends DataStructureBean {
    private TableBean tableBean;
    private String excelName;

    public ExcelDataStructureBean(Table table) {
        this.tableBean = new TableBean(table);
    }

    public void setPrimaryMeasure(Column primaryMeasureColumn, ConceptMutableBean associatedConcept) {
        DataColumnBean primaryMeasure = new DataColumnBean(primaryMeasureColumn, associatedConcept);
        primaryMeasure.setPrimary(true);
        this.tableBean.setPrimaryMeasure(primaryMeasure);
    }

    public void setTimeDimension(Column timeDimensionColumn, ConceptMutableBean associatedConcept) {
        this.tableBean.setTimeDimension(new DataColumnBean(timeDimensionColumn, associatedConcept));
    }

    public void addMeasureColumn(Column measureColumn, ConceptMutableBean associatedConcept) {
        this.tableBean.addMeasureColumn(new DataColumnBean(measureColumn, associatedConcept));
    }

    public void addDimensionColumn(Column dimensionColumn, ConceptMutableBean associatedConcept, CodelistBean associatedCodelist) {
        DataColumnBean dimensionBean = new DataColumnBean(dimensionColumn, associatedConcept);
        this.tableBean.addDimensionColumn(dimensionBean);
        if (associatedCodelist != null) {
            dimensionBean.setCodelist(associatedCodelist);
            super.addAssociatedCodelist(dimensionColumn.getLocalId().getValue(), associatedCodelist);
        }
    }

    public void addAttributeColumn(Column attributeColumn, ConceptMutableBean associatedConcept, CodelistBean associatedCodelist) {
        DataColumnBean attributeBean = new DataColumnBean(attributeColumn, associatedConcept);
        this.tableBean.addAttributeColumn(attributeBean);
        if (associatedCodelist != null) {
            attributeBean.setCodelist(associatedCodelist);
            super.addAssociatedCodelist(attributeColumn.getLocalId().getValue(), associatedCodelist);
        }
    }

    public TableBean getTableBean() {
        return this.tableBean;
    }

    public void addData(String columnName, List<String> data) {
        DataColumnBean column = this.tableBean.getColumnByName(columnName);
        if (column != null) {
            column.setData(data);
        }
    }

    public String getExcelName() {
        return this.excelName;
    }

    public void setExcelName(String excelName) {
        this.excelName = excelName;
    }
}

