/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.template.conceptscheme;

import java.util.List;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Template;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptSchemeMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.conceptscheme.ConceptMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.conceptscheme.ConceptSchemeMutableBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXConceptSchemeGeneratorFromTemplate {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Template template;
    private String targetAgency;
    private String targetId;
    private String targetVersion;

    public SDMXConceptSchemeGeneratorFromTemplate(Template template, String targetId, String targetAgency, String targetVersion) {
        this.template = template;
        this.targetAgency = targetAgency;
        this.targetVersion = targetVersion;
        this.targetId = targetId;
    }

    public void populateConceptsScheme(ConceptSchemeMutableBean conceptScheme) throws WorkerException {
        this.log.debug("Loading columns");
        List columns = this.template.getActualStructure();
        this.log.debug("Columns loaded");
        for (TemplateColumn column : columns) {
            this.log.debug("Generating concept for column " + column.getLabel());
            ConceptMutableBean columnConcept = this.createConceptBean(column);
            conceptScheme.addItem((ItemMutableBean)columnConcept);
            this.log.debug("Concept generated");
        }
    }

    public ConceptMutableBean createConceptBean(TemplateColumn<?> templateColumn) {
        this.log.debug("Generating concept mutable bean for column " + templateColumn.getLabel());
        char[] labelChars = templateColumn.getLabel().toCharArray();
        StringBuilder conceptIdBuilder = new StringBuilder();
        char[] cArray = labelChars;
        int n = labelChars.length;
        int n2 = 0;
        while (n2 < n) {
            char labelChar = cArray[n2];
            if (labelChar != ' ') {
                conceptIdBuilder.append(labelChar);
            }
            ++n2;
        }
        this.log.debug("Concept id = " + conceptIdBuilder.toString());
        ConceptMutableBeanImpl concept = new ConceptMutableBeanImpl();
        concept.setId(String.valueOf(conceptIdBuilder.toString()) + "_concept");
        concept.setParentAgency(this.targetAgency);
        concept.addName("en", templateColumn.getLabel());
        return concept;
    }

    public ConceptSchemeMutableBean createConceptSchemeBean() {
        ConceptSchemeMutableBeanImpl conceptScheme = new ConceptSchemeMutableBeanImpl();
        String conceptSchemeID = String.valueOf(this.targetId) + "_concepts";
        conceptScheme.setId(conceptSchemeID);
        conceptScheme.setAgencyId(this.targetAgency);
        conceptScheme.setVersion(this.targetVersion);
        conceptScheme.addName("en", String.valueOf(this.targetId) + " Concepts");
        return conceptScheme;
    }
}

