package org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.data.analtsis.excel.engine.exceptions.ExcelNotSavedException;
import org.gcube.data.analtsis.excel.engine.impl.WorkspaceExcelGenerator;
import org.gcube.data.analysis.excel.data.TableMetaData;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.ExcelGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ExcelGeneratorAbstractImpl implements ExcelGenerator{

	private Logger logger;
	private TableMetaData tableMetadata;
	
	
	public ExcelGeneratorAbstractImpl ()
	{
		this.logger = LoggerFactory.getLogger(this.getClass());
		
	}
	
	protected void setTable (TableMetaData tableMetadata)
	{
		this.tableMetadata = tableMetadata;
	}
	
	
	
	public void generateExcel (String fileName, String folderName)
	{
		logger.debug("Generating sample excel on the workspace");
		String securityToken = SecurityTokenProvider.instance.get();
		if (securityToken == null)
		{
			logger.error("Token not found");
			
		}
		else
		{
			logger.debug("Token retrieved");
			logger.debug("Saving file "+ fileName+ " in the folder "+folderName);
			WorkspaceExcelGenerator excelGenerator = new WorkspaceExcelGenerator(tableMetadata, securityToken, fileName, folderName);
			logger.debug("Generating file..");
			excelGenerator.generate();
			logger.debug("File generated");
			
			try
			{
				logger.debug("Saving file..");
				excelGenerator.save();
				logger.debug("File saved");
			} catch (ExcelNotSavedException e)
			{
				logger.warn("Excel file not saved",e);
				
			}
			

		}

	}
}
