/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.dataset;

import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.resources.InternalURI;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.sdmx.dataset.DatasetWorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.sdmx.dataset.ds.DataSourceConfigurationBean;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableURIResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ComponentMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.conceptscheme.ConceptSchemeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.AttributeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataStructureMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DataflowMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionListMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.DimensionMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.datastructure.PrimaryMeasureMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TextTypeWrapperMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.conceptscheme.ConceptMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.conceptscheme.ConceptSchemeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.AttributeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DataStructureMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DimensionListMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.DimensionMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.datastructure.PrimaryMeasureMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.metadatastructure.DataflowMutableBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXDataSetExporter
extends ResourceCreatorWorker {
    private static Logger log = LoggerFactory.getLogger(SDMXDataSetExporter.class);
    private Table table;
    private OperationInvocation invocation;
    private Column primaryMeasure;
    private String registryUrl;
    private String targetAgency;
    private String targetId;
    private String targetVersion;
    private List<LocalizedText> tableNamesMetadata;
    private final String ATTRIBUTE_ASSIGNMENT_STATUS_MANDATORY = "Mandatory";
    private static String errorMessage = "Unable to complete export procedure";

    public SDMXDataSetExporter(Table table, OperationInvocation invocation) {
        super(invocation);
        this.table = table;
        this.invocation = invocation;
    }

    protected ResourcesResult execute() throws WorkerException {
        try {
            DataSourceConfigurationBean datasourceConfigurationBean = new DataSourceConfigurationBean();
            datasourceConfigurationBean.setTable_id(this.table.getName());
            this.retrieveParameters(datasourceConfigurationBean);
            this.loadMetadata();
            this.updateProgress(0.1f, "Creating beans");
            DataStructureMutableBean dataStructure = this.createDataStructureBean(datasourceConfigurationBean);
            ConceptSchemeMutableBean conceptScheme = this.createConceptSchemeBean();
            DataflowMutableBean dataFlow = this.createDataFlowBean(dataStructure);
            this.updateProgress(0.2f, "Populating data structure");
            this.populateDataStructure(dataStructure, conceptScheme, datasourceConfigurationBean);
            this.updateProgress(0.6f, "Publishing");
            this.publishData(dataStructure, conceptScheme, dataFlow);
            this.updateProgress(0.8f, "Finalizing");
            return new ResourcesResult((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(this.registryUrl)), "Codelist SDMX export", String.format("%scodelist/%s/%s/%s/", this.registryUrl, this.targetAgency, this.targetId, this.targetVersion), ResourceType.SDMX));
        }
        catch (RuntimeException e) {
            log.error(errorMessage, (Throwable)e);
            throw new WorkerException(errorMessage, (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new WorkerException(String.format("exported url %s not valid", this.registryUrl), (Throwable)e);
        }
    }

    private void retrieveParameters(DataSourceConfigurationBean datasourceConfigurationBean) {
        this.registryUrl = (String)this.invocation.getParameterInstances().get("registryBaseUrl");
        this.targetAgency = (String)this.invocation.getParameterInstances().get("agency");
        this.targetId = (String)this.invocation.getParameterInstances().get("id");
        this.targetVersion = (String)this.invocation.getParameterInstances().get("version");
        String observationValue = (String)this.invocation.getParameterInstances().get("obsValueColumn");
        this.primaryMeasure = this.table.getColumnById(new ColumnLocalId(observationValue));
        datasourceConfigurationBean.setObservationValue(observationValue);
    }

    private void publishData(DataStructureMutableBean dsd, ConceptSchemeMutableBean concepts, DataflowMutableBean dataFlow) throws WorkerException {
        String url = (String)this.invocation.getParameterInstances().get("registryBaseUrl");
        SDMXRegistryClient registryClient = DatasetWorkerUtils.initSDMXClient(url);
        try {
            log.debug("Publishing concepts...");
            registryClient.publish(concepts.getImmutableInstance());
            log.debug("Concepts published");
        }
        catch (SDMXRegistryClientException e) {
            throw new WorkerException("Unable to publish concepts on registry.", (Throwable)e);
        }
        try {
            log.debug("Publishing dsd...");
            registryClient.publish(dsd.getImmutableInstance());
            log.debug("DSD published");
        }
        catch (SDMXRegistryClientException e) {
            throw new WorkerException("Unable to publish dsd on registry.", (Throwable)e);
        }
        try {
            log.debug("Publishing data flow...");
            registryClient.publish(dataFlow.getImmutableInstance());
            log.debug("Data flow published");
        }
        catch (SDMXRegistryClientException e) {
            throw new WorkerException("Unable to publish dsd on registry.", (Throwable)e);
        }
    }

    private void populateDataStructure(DataStructureMutableBean dataStructure, ConceptSchemeMutableBean conceptScheme, DataSourceConfigurationBean dataSourceConfigurationBean) throws WorkerException {
        List measureColumns = this.table.getColumnsByType(new Class[]{MeasureColumnType.class});
        List dimensionColumns = this.table.getColumnsByType(new Class[]{DimensionColumnType.class});
        List attributeColumns = this.table.getColumnsByType(new Class[]{AttributeColumnType.class});
        Column timeDimensionColumn = (Column)this.table.getColumnsByType(new Class[]{TimeDimensionColumnType.class}).get(0);
        dataSourceConfigurationBean.setObservationTime(timeDimensionColumn.getLocalId().getValue());
        log.debug("Columns loaded");
        boolean found = false;
        Iterator measureColumnsIterator = measureColumns.iterator();
        log.debug("Looking for primary measure column");
        while (measureColumnsIterator.hasNext() && !found) {
            Column column = (Column)measureColumnsIterator.next();
            if (!column.getLocalId().getValue().equals(this.primaryMeasure.getLocalId().getValue())) continue;
            measureColumns.remove(column);
            found = true;
        }
        ConceptMutableBean primaryMeasureConcept = this.createConceptBean(this.primaryMeasure);
        conceptScheme.addItem((ItemMutableBean)primaryMeasureConcept);
        StructureReferenceBeanImpl conceptReferenceBean = new StructureReferenceBeanImpl(primaryMeasureConcept.getParentAgency(), conceptScheme.getId(), this.targetVersion, SDMX_STRUCTURE_TYPE.CONCEPT, new String[]{primaryMeasureConcept.getId()});
        PrimaryMeasureMutableBeanImpl primaryMeasureBean = new PrimaryMeasureMutableBeanImpl();
        primaryMeasureBean.setConceptRef((StructureReferenceBean)conceptReferenceBean);
        primaryMeasureBean.setId("OBS_VALUE");
        dataStructure.setPrimaryMeasure((PrimaryMeasureMutableBean)primaryMeasureBean);
        DimensionListMutableBeanImpl dimensionListBean = new DimensionListMutableBeanImpl();
        this.addMeasureDimensions((DimensionListMutableBean)dimensionListBean, measureColumns, conceptScheme, dataSourceConfigurationBean);
        this.addGenericDimensions((DimensionListMutableBean)dimensionListBean, dimensionColumns, conceptScheme, dataSourceConfigurationBean);
        DimensionMutableBeanImpl timeDimensionBean = new DimensionMutableBeanImpl();
        timeDimensionBean.setId("TIME_PERIOD");
        ConceptMutableBean timeDimensionConcept = this.createConceptBean(timeDimensionColumn);
        conceptScheme.addItem((ItemMutableBean)timeDimensionConcept);
        timeDimensionBean.setConceptRef(this.getConceptReference(conceptScheme, timeDimensionConcept));
        timeDimensionBean.setTimeDimension(true);
        dimensionListBean.addDimension((DimensionMutableBean)timeDimensionBean);
        dataStructure.setDimensionList((DimensionListMutableBean)dimensionListBean);
        this.addAttributes(dataStructure, attributeColumns, conceptScheme, dataSourceConfigurationBean);
    }

    private void addGenericDimensions(DimensionListMutableBean dimensionListBean, List<Column> dimensionColumns, ConceptSchemeMutableBean concepts, DataSourceConfigurationBean dataSourceConfigurationBean) {
        log.debug("Adding dimension list bean");
        for (Column column : dimensionColumns) {
            ConceptMutableBean columnConcept = this.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            DimensionMutableBeanImpl dimensionBean = new DimensionMutableBeanImpl();
            this.setBeanData(column, (ComponentMutableBean)dimensionBean, this.getConceptReference(concepts, columnConcept));
            dimensionListBean.addDimension((DimensionMutableBean)dimensionBean);
            dataSourceConfigurationBean.addDimension(columnConcept.getId(), column.getLocalId().getValue());
        }
    }

    private void addAttributes(DataStructureMutableBean dataStructure, List<Column> attributeColumns, ConceptSchemeMutableBean concepts, DataSourceConfigurationBean dataSourceConfigurationBean) {
        log.debug("Adding attribute list bean");
        for (Column column : attributeColumns) {
            ConceptMutableBean columnConcept = this.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            AttributeMutableBeanImpl attributeBean = new AttributeMutableBeanImpl();
            attributeBean.setAttachmentLevel(ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION);
            attributeBean.setAssignmentStatus("Mandatory");
            this.setBeanData(column, (ComponentMutableBean)attributeBean, this.getConceptReference(concepts, columnConcept));
            dataStructure.addAttribute((AttributeMutableBean)attributeBean);
            dataSourceConfigurationBean.addAttributes(columnConcept.getId(), column.getLocalId().getValue());
        }
    }

    private void addMeasureDimensions(DimensionListMutableBean dimensionListBean, List<Column> measureColumns, ConceptSchemeMutableBean concepts, DataSourceConfigurationBean dataSourceConfigurationBean) {
        log.debug("Adding measure dimension list bean");
        for (Column column : measureColumns) {
            ConceptMutableBean columnConcept = this.createConceptBean(column);
            concepts.addItem((ItemMutableBean)columnConcept);
            DimensionMutableBeanImpl dimensionBean = new DimensionMutableBeanImpl();
            dimensionBean.setMeasureDimension(true);
            this.setBeanData(column, (ComponentMutableBean)dimensionBean, this.getConceptReference(concepts, columnConcept));
            dimensionListBean.addDimension((DimensionMutableBean)dimensionBean);
            dataSourceConfigurationBean.addDimension(columnConcept.getId(), column.getLocalId().getValue());
        }
    }

    private StructureReferenceBean getConceptReference(ConceptSchemeMutableBean conceptScheme, ConceptMutableBean concept) {
        return new StructureReferenceBeanImpl(concept.getParentAgency(), conceptScheme.getId(), this.targetVersion, SDMX_STRUCTURE_TYPE.CONCEPT, new String[]{concept.getId()});
    }

    private void setBeanData(Column column, ComponentMutableBean componentBean, StructureReferenceBean conceptRef) {
        componentBean.setId(String.valueOf(column.getName()) + "_DSD");
        componentBean.setConceptRef(conceptRef);
    }

    private ConceptMutableBean createConceptBean(Column column) {
        log.debug("Generating concept mutable bean for column " + column.getName());
        ConceptMutableBeanImpl concept = new ConceptMutableBeanImpl();
        concept.setId(String.valueOf(column.getName()) + "_concept");
        concept.setParentAgency(this.targetAgency);
        try {
            List conceptNames = ((NamesMetadata)column.getMetadata(NamesMetadata.class)).getTexts();
            log.debug("Concept names size " + conceptNames.size());
            concept.setNames(this.getNamesMetadata(conceptNames, null, null));
        }
        catch (NoSuchMetadataException noSuchMetadataException) {
            // empty catch block
        }
        return concept;
    }

    private DataStructureMutableBean createDataStructureBean(DataSourceConfigurationBean datasourceConfigurationBean) {
        DataStructureMutableBeanImpl dataStructure = new DataStructureMutableBeanImpl();
        dataStructure.setAgencyId(this.targetAgency);
        dataStructure.setVersion(this.targetVersion);
        String dsdId = String.valueOf(this.targetId) + "_DSD";
        dataStructure.setId(dsdId);
        dataStructure.setNames(this.getNamesMetadata(this.tableNamesMetadata, String.valueOf(this.targetId) + " Data Structure Definition", "en"));
        datasourceConfigurationBean.setDsdId(dsdId);
        return dataStructure;
    }

    private DataflowMutableBean createDataFlowBean(DataStructureMutableBean dataStructure) {
        DataflowMutableBeanImpl dataFlow = new DataflowMutableBeanImpl();
        log.debug("Populating data flow bean");
        dataFlow.setAgencyId(this.targetAgency);
        dataFlow.setDataStructureRef((StructureReferenceBean)new StructureReferenceBeanImpl(dataStructure.getAgencyId(), dataStructure.getId(), this.targetVersion, SDMX_STRUCTURE_TYPE.DSD, new String[0]));
        dataFlow.setId(String.valueOf(this.targetId) + "_dataFlow");
        dataFlow.setNames(this.getNamesMetadata(this.tableNamesMetadata, String.valueOf(this.targetId) + " Data Flow", "en"));
        return dataFlow;
    }

    private ConceptSchemeMutableBean createConceptSchemeBean() {
        ConceptSchemeMutableBeanImpl conceptScheme = new ConceptSchemeMutableBeanImpl();
        String conceptID = String.valueOf(this.table.getName()) + "_concepts";
        conceptScheme.setId(conceptID);
        conceptScheme.setAgencyId(this.targetAgency);
        conceptScheme.setVersion(this.targetVersion);
        conceptScheme.setNames(this.getNamesMetadata(this.tableNamesMetadata, String.valueOf(conceptID) + " Concepts", "en"));
        return conceptScheme;
    }

    private void loadMetadata() {
        try {
            this.tableNamesMetadata = ((NamesMetadata)this.table.getMetadata(NamesMetadata.class)).getTexts();
        }
        catch (NoSuchMetadataException e) {
            this.tableNamesMetadata = Lists.newArrayList();
        }
    }

    private List<TextTypeWrapperMutableBean> getNamesMetadata(List<LocalizedText> metadataValues, String defaultValue, String defaultLocale) {
        ArrayList response = Lists.newArrayList();
        if (metadataValues.size() == 0 && defaultValue != null) {
            log.warn("Names Metadata: using default value " + defaultValue);
            response.add(new TextTypeWrapperMutableBeanImpl(defaultLocale, defaultValue));
        } else {
            for (LocalizedText text : metadataValues) {
                log.debug("Adding metadata value " + text.getValue() + " " + text.getLocale());
                response.add(new TextTypeWrapperMutableBeanImpl(text.getLocale(), text.getValue()));
            }
        }
        return response;
    }
}

