/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ExportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.sdmx.WorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.sdmxsource.sdmx.api.model.mutable.base.AnnotationMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodelistMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.AnnotationMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TextTypeWrapperMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.CodeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.CodelistMutableBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXCodelistExporter
extends Worker {
    private static Logger log = LoggerFactory.getLogger(SDMXCodelistExporter.class);
    private Table table;
    private OperationInvocation invocation;
    private DatabaseConnectionProvider connectionProvider;
    private Column codeColumn;
    private List<Column> nameColumns;
    private List<Column> descriptionColumns;
    private List<Column> annotationColumns;
    private CubeManager cubeManager;
    private String targetUrl;
    private String targetAgency;
    private String targetId;
    private String targetVersion;
    private static String errorMessage = "Unable to complete export procedure";

    public SDMXCodelistExporter(Table table, OperationInvocation invocation, DatabaseConnectionProvider connectionProvider, CubeManager cubeManager) {
        super(invocation);
        this.table = table;
        this.invocation = invocation;
        this.connectionProvider = connectionProvider;
        this.cubeManager = cubeManager;
    }

    protected WorkerResult execute() throws WorkerException {
        try {
            this.retrieveNeededColumns();
            this.retrieveParameters();
            this.updateProgress(0.1f);
            CodelistMutableBean codelist = this.createBaseCodelistBean();
            this.updateProgress(0.2f);
            this.populateCodelistWithCodes(codelist);
            this.updateProgress(0.6f);
            this.publishCodelist(codelist);
            this.updateProgress(0.8f);
            Table resultTable = this.createMetaTable();
            return new ImmutableWorkerResult(resultTable);
        }
        catch (RuntimeException e) {
            log.error(errorMessage, (Throwable)e);
            throw new WorkerException(errorMessage, (Throwable)e);
        }
    }

    private void retrieveParameters() {
        this.targetUrl = (String)this.invocation.getParameterInstances().get("registryBaseUrl");
        this.targetAgency = (String)this.invocation.getParameterInstances().get("agency");
        this.targetId = (String)this.invocation.getParameterInstances().get("id");
        this.targetVersion = (String)this.invocation.getParameterInstances().get("version");
    }

    private Table createMetaTable() {
        TableMetaCreator tmc = this.cubeManager.modifyTableMeta(this.table.getId());
        tmc.setTableMetadata(new TableMetadata[]{new ExportMetadata("SDMX", String.format("%scodelist/%s/%s/%s/", this.targetUrl, this.targetAgency, this.targetId, this.targetVersion), new Date())});
        return tmc.create();
    }

    private void publishCodelist(CodelistMutableBean codelist) throws WorkerException {
        String url = (String)this.invocation.getParameterInstances().get("registryBaseUrl");
        SDMXRegistryClient registryClient = WorkerUtils.initSDMXClient(url);
        try {
            registryClient.publish(codelist.getImmutableInstance());
        }
        catch (SDMXRegistryClientException e) {
            throw new WorkerException("Unable to publish codelist on registry.", (Throwable)e);
        }
    }

    private void populateCodelistWithCodes(CodelistMutableBean codelist) throws WorkerException {
        String query = this.buildSqlQuery(this.codeColumn, this.nameColumns, this.descriptionColumns, this.annotationColumns);
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.connectionProvider.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String columnDataLocale;
                CodeMutableBeanImpl code = new CodeMutableBeanImpl();
                code.setId(rs.getString(this.codeColumn.getName()));
                for (Column column : this.nameColumns) {
                    try {
                        columnDataLocale = ((DataLocaleMetadata)column.getMetadata(DataLocaleMetadata.class)).getLocale();
                        code.addName(columnDataLocale, rs.getString(column.getName()));
                    }
                    catch (NoSuchMetadataException e) {}
                }
                for (Column column : this.descriptionColumns) {
                    try {
                        columnDataLocale = ((DataLocaleMetadata)column.getMetadata(DataLocaleMetadata.class)).getLocale();
                        code.addDescription(columnDataLocale, rs.getString(column.getName()));
                    }
                    catch (NoSuchMetadataException e) {}
                }
                for (Column column : this.annotationColumns) {
                    try {
                        AnnotationMutableBeanImpl annotation = new AnnotationMutableBeanImpl();
                        LocalizedText text = ((NamesMetadata)column.getMetadata(NamesMetadata.class)).getTextWithLocale("en");
                        annotation.setTitle(text.getValue());
                        ArrayList annotationValues = Lists.newArrayList();
                        annotationValues.add(new TextTypeWrapperMutableBeanImpl(text.getLocale(), rs.getString(column.getName())));
                        annotation.setText((List)annotationValues);
                        code.addAnnotation((AnnotationMutableBean)annotation);
                    }
                    catch (NoSuchMetadataException e) {}
                }
                codelist.addItem((ItemMutableBean)code);
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Unable to execute database query.";
                log.error(msg, (Throwable)e);
                if (e.getNextException() != null) {
                    log.error("Inner Exception: ", (Throwable)e.getNextException());
                }
                throw new WorkerException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly(stmt);
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
    }

    private CodelistMutableBean createBaseCodelistBean() {
        CodelistMutableBeanImpl codelist = new CodelistMutableBeanImpl();
        codelist.setAgencyId((String)this.invocation.getParameterInstances().get("agency"));
        codelist.setVersion((String)this.invocation.getParameterInstances().get("version"));
        codelist.setId((String)this.invocation.getParameterInstances().get("id"));
        try {
            ArrayList names = Lists.newArrayList();
            for (LocalizedText text : ((NamesMetadata)this.table.getMetadata(NamesMetadata.class)).getTexts()) {
                names.add(new TextTypeWrapperMutableBeanImpl(text.getLocale(), text.getValue()));
            }
            codelist.setNames((List)names);
        }
        catch (NoSuchMetadataException e) {
            // empty catch block
        }
        ArrayList codelistAnnotations = Lists.newArrayList();
        AnnotationMutableBeanImpl sourceAnnotation = new AnnotationMutableBeanImpl();
        sourceAnnotation.setTitle("Source");
        ArrayList textList = Lists.newArrayList();
        textList.add(new TextTypeWrapperMutableBeanImpl("en", "Tabular Data"));
        sourceAnnotation.setText((List)textList);
        codelistAnnotations.add(sourceAnnotation);
        codelist.setAnnotations((List)codelistAnnotations);
        return codelist;
    }

    private void retrieveNeededColumns() {
        this.codeColumn = (Column)this.table.getColumnsByType(new Class[]{CodeColumnType.class}).get(0);
        this.nameColumns = this.table.getColumnsByType(new Class[]{CodeNameColumnType.class});
        this.descriptionColumns = this.table.getColumnsByType(new Class[]{CodeDescriptionColumnType.class});
        this.annotationColumns = this.table.getColumnsByType(new Class[]{AnnotationColumnType.class});
    }

    private String buildSqlQuery(Column codeColumn, List<Column> nameColumns, List<Column> descriptionColumns, List<Column> annotationColumns) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT " + codeColumn.getName() + ", ");
        for (Column column : nameColumns) {
            sql.append(column.getName() + " , ");
        }
        for (Column column : descriptionColumns) {
            sql.append(column.getName() + " , ");
        }
        for (Column column : annotationColumns) {
            sql.append(column.getName() + " , ");
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(" FROM " + this.table.getName() + ";");
        return sql.toString();
    }
}

