/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ExportWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.sdmx.SDMXCodelistExporter;
import org.gcube.data.analysis.tabulardata.operation.sdmx.WorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationNotEligibleException;

@Singleton
public class SDMXCodelistExporterFactory
extends ExportWorkerFactory {
    private static final OperationDescriptor.OperationId operationId = new OperationDescriptor.OperationId(201L);
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;

    @Inject
    public SDMXCodelistExporterFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public EligibleOperation getEligibleOperation(TableId tableId) throws OperationNotEligibleException {
        return this.getEligibleOperation(this.cubeManager.getTable(tableId));
    }

    private EligibleOperation getEligibleOperation(Table table) throws OperationNotEligibleException {
        try {
            this.checkTableEligibility(table);
        }
        catch (Exception e) {
            throw new OperationNotEligibleException(table.getId(), e.getMessage());
        }
        return this.createEligibleOperation(table.getId());
    }

    private void checkTableEligibility(Table table) throws Exception {
        if (!table.getTableType().equals((Object)new CodelistTableType())) {
            throw new Exception("The table is not a codelist");
        }
        if (table.getColumnsByType(new Class[]{CodeColumnType.class}).isEmpty()) {
            throw new Exception("The table does not have a Code column");
        }
        if (table.getColumnsByType(new Class[]{CodeNameColumnType.class}).isEmpty()) {
            throw new Exception("The table does not have Code name columns");
        }
        List columnsToCheckForDataLocale = table.getColumnsByType(new Class[]{CodeNameColumnType.class, CodeDescriptionColumnType.class, AnnotationColumnType.class});
        try {
            for (Column column : columnsToCheckForDataLocale) {
                column.getMetadata(DataLocaleMetadata.class);
            }
        }
        catch (NoSuchMetadataException e) {
            throw new Exception("A column is missing data locale metadata");
        }
    }

    private EligibleOperation createEligibleOperation(TableId id) {
        return new EligibleOperation(this.getOperationDescriptor(), parameters, id);
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.checkInvocation(invocation);
        Table table = this.cubeManager.getTable(invocation.getTargetTableId());
        return new SDMXCodelistExporter(table, invocation, this.connectionProvider, this.cubeManager);
    }

    private void checkInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        TableId tableId = invocation.getTargetTableId();
        if (tableId == null) {
            throw new InvalidInvocationException(invocation, "No table id was provided");
        }
        try {
            this.checkTableEligibility(this.cubeManager.getTable(tableId));
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, "Target table is not a valid table");
        }
        WorkerUtils.checkParameters(parameters, invocation);
    }

    protected String getOperationName() {
        return "Export Codelist to SDMX registry";
    }

    protected String getOperationDescription() {
        return "Export a tabular data codelist to a remote SDMX registry";
    }

    protected OperationDescriptor.OperationId getOperationId() {
        return operationId;
    }

    static {
        parameters.add((Parameter)new RegexpStringParameter("registryBaseUrl", "Registry REST URL", "Target SDMX Registry REST Service base URL", Cardinality.ONE, "^https?://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"));
        parameters.add((Parameter)new RegexpStringParameter("agency", "Agency", "SDMX Agency", Cardinality.ONE, "[A-z0-9_-]+"));
        parameters.add((Parameter)new RegexpStringParameter("id", "Id", "SDMX Codelist id", Cardinality.ONE, "[A-z0-9_-]+"));
        parameters.add((Parameter)new RegexpStringParameter("version", "Version", "SDMX Codelist version", Cardinality.ONE, "[0-9]+\\.[0-9]+"));
    }
}

