/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateRulesFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidityResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

public class ValidateRules
extends ValidationWorker {
    CubeManager cubeManager;
    ValidateDataWithExpressionFactory validateDataWithExpression;

    public ValidateRules(OperationInvocation sourceInvocation, CubeManager cubeManager, ValidateDataWithExpressionFactory validateDataWithExpression) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.validateDataWithExpression = validateDataWithExpression;
    }

    protected ValidityResult execute() throws WorkerException, OperationAbortedException {
        ArrayList validationDescriptors = new ArrayList();
        boolean isValid = true;
        this.updateProgress(0.05f, "retrieving parameters");
        List<Map<String, Object>> rules = this.getRules();
        this.updateProgress(0.1f, "validating rules");
        float singleProgress = 0.8f / (float)rules.size();
        for (int i = 0; i < rules.size(); ++i) {
            Map<String, Object> ruleMapping = rules.get(i);
            String ruleName = (String)ruleMapping.get(ValidateRulesFactory.NAME_PARAMETER.getIdentifier());
            this.updateProgress(0.1f + singleProgress * (float)(i + 1), "validating rule " + ruleName);
            this.checkAborted();
            WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.validateDataWithExpression);
            HashMap<String, Object> wrapperParameter = new HashMap<String, Object>();
            wrapperParameter.put(ValidateDataWithExpressionFactory.EXPRESSION_PARAMETER.getIdentifier(), ruleMapping.get(ValidateRulesFactory.EXPRESSION_PARAMETER.getIdentifier()));
            wrapperParameter.put(ValidateDataWithExpressionFactory.VALIDATION_TITLE_PARAMETER.getIdentifier(), ruleName);
            try {
                wrapper.execute(this.getSourceInvocation().getTargetTableId(), null, wrapperParameter);
            }
            catch (InvalidInvocationException e) {
                throw new WorkerException("error invoking rule " + ruleName, (Throwable)e);
            }
            validationDescriptors.addAll(((ValidityResult)wrapper.getResult()).getValidationDescriptors());
            isValid = isValid && ((ValidityResult)wrapper.getResult()).isValid();
        }
        this.updateProgress(0.95f, "preparing results");
        return new ValidityResult(isValid, validationDescriptors);
    }

    List<Map<String, Object>> getRules() {
        return (List)this.getSourceInvocation().getParameterInstances().get(ValidateRulesFactory.RULES_PARAMETER.getIdentifier());
    }
}

