/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.DimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.mapping.SQLModelMapper;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GenericMapMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.HarmonizationRuleTable;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.relationship.ImmutableColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeColumnTypeTransformationFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.utils.Harmonizations;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateAmbiguousReferenceFactory;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ColumnCreatorWorker;

public class ChangeToDimensionColumn
extends ColumnCreatorWorker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    private SQLModelMapper modelMapper;
    private Table targetTable;
    private Column targetColumn;
    private Table refTable;
    private Column refColumn;
    private Table newTable;
    private Column dimensionColumn;
    private Map<TDTypeValue, Long> codeMapping;

    public ChangeToDimensionColumn(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory evaluatorFactory, SQLModelMapper modelMapper) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.evaluatorFactory = evaluatorFactory;
        this.modelMapper = modelMapper;
    }

    protected WorkerResult execute() throws WorkerException, OperationAbortedException {
        this.retrieveParameters();
        this.updateProgress(0.1f, "creating new table");
        this.checkAborted();
        this.createNewTable();
        this.updateProgress(0.5f, "filling table with data");
        this.checkAborted();
        this.applyHarmonizationsIfAny();
        this.checkAborted();
        this.fillNewTableWithData();
        this.checkAborted();
        this.newTable = this.cubeManager.removeColumn(this.newTable.getId(), this.targetColumn.getLocalId());
        this.updateProgress(0.8f, "preparating table for future rollback");
        return new ImmutableWorkerResult(this.newTable, this.createDiff(this.targetTable, this.targetColumn));
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
        ColumnReference columnReferenceParam = (ColumnReference)OperationHelper.getParameter((LeafParameter)ValidateDimensionColumnFactory.TARGET_COLUMN_PARAMETER, (OperationInvocation)this.getSourceInvocation());
        this.refTable = this.cubeManager.getTable(columnReferenceParam.getTableId());
        this.refColumn = this.refTable.getColumnById(columnReferenceParam.getColumnId());
        try {
            this.codeMapping = (Map)OperationHelper.getParameter((LeafParameter)ValidateAmbiguousReferenceFactory.MAPPING_PARAMETER, (OperationInvocation)this.getSourceInvocation());
        }
        catch (Exception e) {
            this.codeMapping = Collections.emptyMap();
        }
    }

    private void createNewTable() {
        ImmutableColumnRelationship relationship = new ImmutableColumnRelationship(this.refTable.getId(), this.refColumn.getLocalId());
        this.dimensionColumn = new DimensionColumnFactory().create((ColumnRelationship)relationship);
        ArrayList<ColumnMetadata> toSetMeta = new ArrayList<ColumnMetadata>();
        if (this.targetColumn.contains(NamesMetadata.class)) {
            toSetMeta.add(this.targetColumn.getMetadata(NamesMetadata.class));
        }
        if (this.getSourceInvocation().getParameterInstances().containsKey(ChangeColumnTypeTransformationFactory.ADDITIONAL_META_PARAMETER.getIdentifier())) {
            Object additional = this.getSourceInvocation().getParameterInstances().get(ChangeColumnTypeTransformationFactory.ADDITIONAL_META_PARAMETER.getIdentifier());
            if (additional instanceof Collection) {
                toSetMeta.addAll((Collection)additional);
            } else {
                toSetMeta.add((ColumnMetadata)additional);
            }
        }
        this.dimensionColumn.setAllMetadata(toSetMeta);
        this.newTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true).addColumnAfter(this.dimensionColumn, this.targetColumn).create();
    }

    public List<ColumnLocalId> getCreatedColumns() {
        return Collections.singletonList(this.dimensionColumn.getLocalId());
    }

    private void fillNewTableWithData() throws WorkerException {
        ArrayList<String> sqlUpdateQueries = new ArrayList<String>();
        sqlUpdateQueries.add(this.getFillDimensionColumnSQLCommand());
        sqlUpdateQueries.addAll(this.getFillMappingColumnSQLCommand(this.codeMapping));
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])sqlUpdateQueries.toArray(new String[sqlUpdateQueries.size()]));
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to create a reference for some data", (Throwable)e);
        }
    }

    private List<String> getFillMappingColumnSQLCommand(Map<TDTypeValue, Long> mapping) {
        if (mapping == null || mapping.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> queries = new ArrayList<String>();
        for (Map.Entry<TDTypeValue, Long> entry : mapping.entrySet()) {
            queries.add(String.format("UPDATE %s SET %s = %s WHERE %s = %s", this.newTable.getName(), this.dimensionColumn.getName(), entry.getValue(), this.targetColumn.getName(), this.evaluatorFactory.getEvaluator((Expression)entry.getKey()).evaluate()));
        }
        return queries;
    }

    private String getFillDimensionColumnSQLCommand() {
        return String.format("UPDATE %1$s AS new_table SET %2$s = refCol.id FROM (SELECT id, %5$s as val FROM %4$s) as refCol WHERE refCol.val=new_Table.%3$s::%6$s;", this.newTable.getName(), this.dimensionColumn.getName(), this.targetColumn.getName(), this.refTable.getName(), this.refColumn.getName(), this.modelMapper.translateDataTypeToSQL(this.refColumn.getDataType()));
    }

    private Table createDiff(Table targetTable, Column targetColumn) {
        ArrayList<Column> columnsToRemove = new ArrayList<Column>(targetTable.getColumns().size() - 1);
        for (Column col : targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            if (col.equals((Object)targetColumn)) continue;
            columnsToRemove.add(col);
        }
        TableCreator tableCreator = this.cubeManager.createTable(targetTable.getTableType()).like(targetTable, true, columnsToRemove);
        Table toReturn = tableCreator.create();
        GenericMapMetadata gmm = new GenericMapMetadata(Collections.singletonMap("referenceColumn", this.dimensionColumn.getLocalId().getValue()));
        return this.cubeManager.modifyTableMeta(toReturn.getId()).setTableMetadata(new TableMetadata[]{gmm}).create();
    }

    private void applyHarmonizationsIfAny() throws WorkerException {
        try {
            HarmonizationRuleTable existingRuleTable = (HarmonizationRuleTable)this.refTable.getMetadata(HarmonizationRuleTable.class);
            if (Harmonizations.isColumnUnderRules(this.refColumn.getLocalId(), existingRuleTable, this.connectionProvider, this.evaluatorFactory)) {
                Harmonizations.harmonizeTable(existingRuleTable, this.refTable.getColumnReference(this.refColumn), this.newTable.getColumnReference(this.targetColumn), this.newTable, this.connectionProvider, this.evaluatorFactory);
            }
        }
        catch (NoSuchMetadataException existingRuleTable) {
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to apply harmonizations", (Throwable)e);
        }
    }
}

