/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.validation.DuplicateValuesInColumnValidator;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

@Singleton
public class DuplicateValuesInColumnValidatorFactory
extends ColumnValidatorFactory {
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    private static final OperationId OPERATION_ID = new OperationId(5004L);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory evaluatorfactory;

    @Inject
    public DuplicateValuesInColumnValidatorFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory factory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.evaluatorfactory = factory;
    }

    public ValidationWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        return new DuplicateValuesInColumnValidator(invocation, this.cubeManager, this.connectionProvider, this.evaluatorfactory);
    }

    protected String getOperationName() {
        return "Duplicate Values in Column Validator";
    }

    protected String getOperationDescription() {
        return "Checks for duplicate values in selected column.";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        Column col = this.cubeManager.getTable(invocation.getTargetTableId()).getColumnById(invocation.getTargetColumnId());
        return String.format("Check if %s is unique", OperationHelper.retrieveColumnLabel((Column)col));
    }
}

