/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.TableReferenceReplacer;
import org.gcube.data.analysis.tabulardata.expression.evaluator.EvaluatorException;
import org.gcube.data.analysis.tabulardata.expression.evaluator.description.DescriptionExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GlobalDataValidationReportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.ValidationHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidityResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateDataWithExpression
extends ValidationWorker {
    private static final Logger log = LoggerFactory.getLogger(ValidateDataWithExpression.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Expression validationExpression;
    private String expressionDescription = null;
    private String validationTitle = null;
    private Column validationColumn;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory;
    private int validationCode = 100;
    private List<Column> evaluatedColumns = new ArrayList<Column>();
    private ValidationDescriptor validationDescriptors;

    public ValidateDataWithExpression(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory, DescriptionExpressionEvaluatorFactory descriptionEvaluatorFactory) {
        super(invocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
        this.descriptionEvaluatorFactory = descriptionEvaluatorFactory;
    }

    protected ValidityResult execute() throws WorkerException, OperationAbortedException {
        this.initiate();
        this.updateProgress(0.1f, "Creating validation structure");
        this.checkAborted();
        this.addValidationColumn();
        this.updateProgress(0.4f, "Filling validation column");
        this.checkAborted();
        this.fillValidationColumn();
        this.updateProgress(0.7f, "Finalizing validation");
        this.checkAborted();
        return new ValidityResult(this.evaluateValidityAndUpdateTableMeta() == 0, Collections.singletonList(this.validationDescriptors));
    }

    private void initiate() throws WorkerException {
        try {
            OperationInvocation invocation = this.getSourceInvocation();
            this.targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
            this.validationExpression = (Expression)invocation.getParameterInstances().get(ValidateDataWithExpressionFactory.EXPRESSION_PARAMETER.getIdentifier());
            TableReferenceReplacer replacer = new TableReferenceReplacer(this.validationExpression);
            for (TableId tableId : replacer.getTableIds()) {
                if (!tableId.equals((Object)this.targetTable.getId())) continue;
                for (ColumnReference ref : replacer.getReferences(tableId)) {
                    Column col = this.targetTable.getColumnById(ref.getColumnId());
                    this.evaluatedColumns.add(col);
                }
            }
            this.expressionDescription = invocation.getParameterInstances().containsKey(ValidateDataWithExpressionFactory.DESCRIPTION_PARAMETER.getIdentifier()) ? (String)invocation.getParameterInstances().get(ValidateDataWithExpressionFactory.DESCRIPTION_PARAMETER.getIdentifier()) : (String)this.descriptionEvaluatorFactory.getEvaluator(this.validationExpression).evaluate();
            if (invocation.getParameterInstances().containsKey(ValidateDataWithExpressionFactory.VALIDATION_CODE_PARAMETER.getIdentifier())) {
                try {
                    this.validationCode = Integer.parseInt((String)invocation.getParameterInstances().get(ValidateDataWithExpressionFactory.VALIDATION_CODE_PARAMETER.getIdentifier()));
                }
                catch (NumberFormatException e) {
                    log.warn("validation code not valid on ValidateExpresion parameter");
                }
            }
            this.validationTitle = invocation.getParameterInstances().containsKey(ValidateDataWithExpressionFactory.VALIDATION_TITLE_PARAMETER.getIdentifier()) ? (String)invocation.getParameterInstances().get(ValidateDataWithExpressionFactory.VALIDATION_TITLE_PARAMETER.getIdentifier()) : "Expression on " + OperationHelper.getColumnLabelsSnippet(this.evaluatedColumns);
        }
        catch (Exception e) {
            throw new WorkerException("Unable to initiate, wrong parameters configuration", (Throwable)e);
        }
    }

    private int evaluateValidityAndUpdateTableMeta() throws WorkerException {
        try {
            int invalidCount = ValidationHelper.getErrorCount((DatabaseConnectionProvider)this.connectionProvider, (Table)this.targetTable, (Column)this.validationColumn, (SQLExpressionEvaluatorFactory)this.sqlEvaluatorFactory);
            GlobalDataValidationReportMetadata globalMeta = ValidationHelper.createDataValidationReport((Column)this.validationColumn);
            this.validationDescriptors = new ValidationDescriptor(invalidCount == 0, this.validationTitle, this.expressionDescription, this.validationCode);
            DataValidationMetadata validationMeta = new DataValidationMetadata(new Validation(this.expressionDescription, invalidCount == 0, this.validationCode), invalidCount);
            this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{validationMeta}).setTableMetadata(new TableMetadata[]{globalMeta}).create();
            return invalidCount;
        }
        catch (Exception e) {
            throw new WorkerException("Unable to evaluate global validation", (Throwable)e);
        }
    }

    private void fillValidationColumn() throws WorkerException {
        try {
            SQLHelper.executeSQLCommand((String)this.generateValidationSqlCommand(), (DatabaseConnectionProvider)this.connectionProvider);
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while executing SQL command", (Throwable)e);
        }
    }

    private String generateValidationSqlCommand() throws WorkerException {
        try {
            this.validationExpression.validate();
            return String.format("UPDATE %s SET %s = true WHERE %s;", this.targetTable.getName(), this.validationColumn.getName(), this.sqlEvaluatorFactory.getEvaluator(this.validationExpression).evaluate());
        }
        catch (EvaluatorException e) {
            throw new WorkerException("Unable to evaluate epression", (Throwable)e);
        }
        catch (MalformedExpressionException e) {
            throw new WorkerException("Unable to evaluate epression", (Throwable)e);
        }
    }

    private void addValidationColumn() throws WorkerException {
        DataValidationMetadata validationMeta = new DataValidationMetadata(new Validation(this.expressionDescription, true, this.validationCode), 0);
        this.validationColumn = new ValidationColumnFactory().useDefaultValue((TDTypeValue)new TDBoolean(false)).create((LocalizedText)new ImmutableLocalizedText(this.validationTitle), validationMeta);
        this.targetTable = this.cubeManager.addValidations(this.targetTable.getId(), new Column[]{this.validationColumn});
        log.debug("Added validation column:\n" + this.targetTable);
        ValidationReferencesMetadata meta = new ValidationReferencesMetadata(this.evaluatedColumns.toArray(new Column[this.evaluatedColumns.size()]));
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{meta}).create();
    }
}

