/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MultivaluedStringParameter;
import org.gcube.data.analysis.tabulardata.operation.table.ChangeTableType;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateTableFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

@Singleton
public class ChangeTableTypeFactory
extends TableTransformationWorkerFactory {
    public static MultivaluedStringParameter TABLE_TYPE_PARAMETER;
    private static final OperationId OPERATION_ID;
    private static final Map<String, TableType> availableTableTypes;
    private static List<Parameter> parameters;
    @Inject
    private CubeManager cubeManager;
    @Inject
    private ValidateTableFactory validationFactory;

    public DataWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        Table targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        String targetTableTypeName = (String)OperationHelper.getParameter((LeafParameter)TABLE_TYPE_PARAMETER, (OperationInvocation)invocation);
        TableType targetTableType = availableTableTypes.get(targetTableTypeName);
        return new ChangeTableType(invocation, this.cubeManager, targetTable, targetTableType);
    }

    public static TableType getTableType(String targetTableTypeName) {
        return availableTableTypes.get(targetTableTypeName);
    }

    protected String getOperationName() {
        return "Change table type";
    }

    protected String getOperationDescription() {
        return "Modify the table type";
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    public List<WorkerFactory<ValidationWorker>> getPrecoditionValidations() {
        return Collections.singletonList(this.validationFactory);
    }

    public String describeInvocation(OperationInvocation arg0) throws InvalidInvocationException {
        String targetTypeName = (String)OperationHelper.getParameter((LeafParameter)TABLE_TYPE_PARAMETER, (OperationInvocation)arg0);
        return String.format("Set table as %s", targetTypeName);
    }

    static {
        OPERATION_ID = new OperationId(1002L);
        availableTableTypes = new HashMap<String, TableType>();
        availableTableTypes.put(new GenericTableType().getName(), (TableType)new GenericTableType());
        availableTableTypes.put(new DatasetTableType().getName(), (TableType)new DatasetTableType());
        availableTableTypes.put(new CodelistTableType().getName(), (TableType)new CodelistTableType());
        TABLE_TYPE_PARAMETER = new MultivaluedStringParameter("tableType", "Table Type", "Table type", Cardinality.ONE, new ArrayList<String>(availableTableTypes.keySet()));
        parameters = Collections.singletonList(TABLE_TYPE_PARAMETER);
    }
}

